/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.storage;

import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.storage.ILicenseFileStorageClient;
import com.itextpdf.licensing.base.util.SigningUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LicenseFilesCache {
    static final long DEFAULT_RETRIEVE_LICENSE_FILES_WAIT_TIME = 3600000L;
    private final Map<String, LicenseFilesWithTimestamp> cache = new ConcurrentHashMap<String, LicenseFilesWithTimestamp>();
    private final Object retrieveLock = new Object();
    private final ILicenseFileStorageClient storageRetriever;
    private final long retrieveLicenseFilesWaitTime;

    public LicenseFilesCache(long updateLicenseFilesWaitTime, ILicenseFileStorageClient storageRetriever) {
        this.retrieveLicenseFilesWaitTime = updateLicenseFilesWaitTime;
        this.storageRetriever = storageRetriever;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseFile retrieveUpToDateLicenseFile(LicenseFile licenseFile) {
        SigningUtil.checkSignature(licenseFile);
        Object object = this.retrieveLock;
        synchronized (object) {
            String productName;
            Map<String, LicenseFile> licenseFiles;
            this.pruneCache();
            String licenseKey = licenseFile.getKey();
            LicenseFilesWithTimestamp filesWithTimestamp = this.cache.get(licenseKey);
            if (filesWithTimestamp == null) {
                List<LicenseFile> upToDateLicenseFiles = this.storageRetriever.getLicenseFilesFromStorage(licenseFile);
                ConcurrentHashMap<String, LicenseFile> upToDateLicenseFilesMap = new ConcurrentHashMap<String, LicenseFile>();
                for (LicenseFile file : upToDateLicenseFiles) {
                    if (!licenseKey.equals(file.getKey())) continue;
                    upToDateLicenseFilesMap.put(file.getProduct(), file);
                }
                filesWithTimestamp = new LicenseFilesWithTimestamp(upToDateLicenseFilesMap, SystemUtil.getRelativeTimeMillis());
                this.cache.put(licenseKey, filesWithTimestamp);
            }
            if (!(licenseFiles = filesWithTimestamp.getLicenseFiles()).containsKey(productName = licenseFile.getProduct())) {
                licenseFiles.put(productName, licenseFile);
            }
            return licenseFiles.get(productName);
        }
    }

    private void pruneCache() {
        HashSet<String> elementsToRemove = new HashSet<String>();
        for (Map.Entry<String, LicenseFilesWithTimestamp> entry : this.cache.entrySet()) {
            long elementTimeStamp = entry.getValue().getTimestamp();
            if (SystemUtil.getRelativeTimeMillis() - elementTimeStamp < this.retrieveLicenseFilesWaitTime) continue;
            elementsToRemove.add(entry.getKey());
        }
        for (String keyToRemove : elementsToRemove) {
            this.cache.remove(keyToRemove);
        }
    }

    private static final class LicenseFilesWithTimestamp {
        private final Map<String, LicenseFile> licenseFiles;
        private final long timestamp;

        public LicenseFilesWithTimestamp(Map<String, LicenseFile> licenseFiles, long timestamp) {
            this.licenseFiles = licenseFiles;
            this.timestamp = timestamp;
        }

        public Map<String, LicenseFile> getLicenseFiles() {
            return this.licenseFiles;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

