/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.info.EventsLimitInfo;
import com.itextpdf.licensing.base.info.LicenceTypeInfo;
import com.itextpdf.licensing.base.info.LicenseInfo;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.licensefile.LicenseType;
import com.itextpdf.licensing.base.util.LimitsUtils;
import java.util.Date;
import java.util.Map;

final class LicenseInfoCreator {
    private LicenseInfoCreator() {
    }

    public static LicenseInfo createLicenseInfo(LicenseFile licenseFile, Map<String, Long> leftLimits) {
        Date expire;
        if (licenseFile.getLimits() == null) {
            throw new IllegalStateException(MessageFormatUtil.format((String)"Can not find limit for product \"{0}\".", (Object[])new Object[]{licenseFile.getProduct()}));
        }
        try {
            expire = DateTimeUtil.parseWithDefaultPattern((String)licenseFile.getExpirationDate());
        }
        catch (Exception ex) {
            throw new IllegalStateException(MessageFormatUtil.format((String)"Invalid expire date for license file which corresponds to \"{0}\" product.", (Object[])new Object[]{licenseFile.getProduct()}));
        }
        EventsLimitInfo eventsLimitInfo = LimitsUtils.createLimitsInfo(licenseFile, leftLimits);
        LicenceTypeInfo licenseType = LicenseInfoCreator.createLicenseType(licenseFile.getLicenseType());
        return new LicenseInfo(licenseFile.getProduct(), expire, licenseType, eventsLimitInfo);
    }

    private static LicenceTypeInfo createLicenseType(LicenseType licenseType) {
        LicenceTypeInfo type;
        switch (licenseType) {
            case oem: {
                type = LicenceTypeInfo.OEM;
                break;
            }
            case nonproduction: {
                type = LicenceTypeInfo.NON_PRODUCTION;
                break;
            }
            case production: {
                type = LicenceTypeInfo.PRODUCTION;
                break;
            }
            case trial: {
                type = LicenceTypeInfo.TRIAL;
                break;
            }
            default: {
                throw new IllegalStateException(MessageFormatUtil.format((String)"Unexpected license type \"{0}\".", (Object[])new Object[]{licenseType}));
            }
        }
        return type;
    }
}

