/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.strategy;

import com.itextpdf.licensing.base.strategy.IStrategy;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogStrategy
implements IStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogStrategy.class);
    private final AtomicLong failCounter = new AtomicLong(0L);
    private final long failLimit;
    private final String logMessage;

    public LogStrategy(String logMessage) {
        this(logMessage, 0L);
    }

    public LogStrategy(String logMessage, long failLimit) {
        this.failLimit = failLimit;
        this.logMessage = logMessage;
    }

    @Override
    public void onFailure() {
        if (this.failCounter.get() == 0L || this.failCounter.incrementAndGet() > this.failLimit) {
            this.failCounter.set(1L);
            LOGGER.warn(this.logMessage);
        }
    }

    @Override
    public void onSuccess() {
        this.failCounter.set(0L);
    }

    @Override
    public void onProcessing() {
    }
}

