/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.licensefile;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.itextpdf.commons.utils.MapUtil;
import com.itextpdf.licensing.base.licensefile.DeploymentType;
import com.itextpdf.licensing.base.licensefile.EventReporting;
import com.itextpdf.licensing.base.licensefile.LicenseType;
import com.itextpdf.licensing.base.licensefile.Licensee;
import com.itextpdf.licensing.base.licensefile.Limit;
import com.itextpdf.licensing.base.licensefile.OnExpirationStrategy;
import com.itextpdf.licensing.base.licensefile.Platform;
import com.itextpdf.licensing.base.licensefile.ProductVersion;
import com.itextpdf.licensing.base.licensefile.SendStatistics;
import java.util.Map;
import java.util.TreeMap;

public final class LicenseFile {
    @JsonProperty(value="product")
    private final String product;
    @JsonProperty(value="licensee")
    private final Licensee licensee;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="creationDate")
    private final String creationDate;
    @JsonProperty(value="expirationDate")
    private final String expirationDate;
    @JsonProperty(value="onExpiration")
    private final OnExpirationStrategy onExpiration;
    @JsonProperty(value="gracePeriod")
    private final String gracePeriod;
    @JsonProperty(value="platform")
    private final Platform platform;
    @JsonProperty(value="licenseType")
    private final LicenseType licenseType;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="productVersion")
    private final ProductVersion productVersion;
    @JsonProperty(value="limits")
    private final Map<String, Limit> limits;
    @JsonProperty(value="eventReporting")
    private final EventReporting eventReporting;
    @JsonProperty(value="producerLine")
    private final String producerLine;
    @JsonProperty(value="comment")
    private final String comment;
    @JsonProperty(value="licenseVersion")
    private final String licenseVersion;
    @JsonProperty(value="configuration")
    private final Map<String, String> configuration;
    @JsonProperty(value="sendStatistics")
    private final SendStatistics sendStatistics;
    @JsonProperty(value="signature")
    private final String signature;

    public LicenseFile(@JsonProperty(value="product") String product, @JsonProperty(value="licensee") Licensee licensee, @JsonProperty(value="key") String key, @JsonProperty(value="creationDate") String creationDate, @JsonProperty(value="expirationDate") String expirationDate, @JsonProperty(value="onExpiration") OnExpirationStrategy onExpiration, @JsonProperty(value="gracePeriod") String gracePeriod, @JsonProperty(value="platform") Platform platform, @JsonProperty(value="licenseType") LicenseType licenseType, @JsonProperty(value="deploymentType") DeploymentType deploymentType, @JsonProperty(value="productVersion") ProductVersion productVersion, @JsonProperty(value="limits") Map<String, Limit> limits, @JsonProperty(value="eventReporting") EventReporting eventReporting, @JsonProperty(value="producerLine") String producerLine, @JsonProperty(value="comment") String comment, @JsonProperty(value="licenseVersion") String licenseVersion, @JsonProperty(value="configuration") Map<String, String> configuration, @JsonProperty(value="sendStatistics") SendStatistics sendStatistics, @JsonProperty(value="signature") String signature) {
        this.product = product;
        this.licensee = licensee;
        this.key = key;
        this.creationDate = creationDate;
        this.expirationDate = expirationDate;
        this.onExpiration = onExpiration;
        this.gracePeriod = gracePeriod;
        this.platform = platform;
        this.licenseType = licenseType;
        this.deploymentType = deploymentType;
        this.productVersion = productVersion;
        this.sendStatistics = sendStatistics;
        this.limits = limits == null ? null : new TreeMap<String, Limit>(limits);
        this.eventReporting = eventReporting;
        this.producerLine = producerLine;
        this.comment = comment;
        this.licenseVersion = licenseVersion;
        this.configuration = configuration == null ? null : new TreeMap<String, String>(configuration);
        this.signature = signature;
    }

    public String getProduct() {
        return this.product;
    }

    public Licensee getLicensee() {
        return this.licensee;
    }

    public String getKey() {
        return this.key;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public OnExpirationStrategy getOnExpiration() {
        return this.onExpiration;
    }

    public String getGracePeriod() {
        return this.gracePeriod;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public ProductVersion getProductVersion() {
        return this.productVersion;
    }

    public Map<String, Limit> getLimits() {
        if (this.limits == null) {
            return null;
        }
        return new TreeMap<String, Limit>(this.limits);
    }

    public EventReporting getEventReporting() {
        return this.eventReporting;
    }

    public String getProducerLine() {
        return this.producerLine;
    }

    public String getComment() {
        return this.comment;
    }

    public String getLicenseVersion() {
        return this.licenseVersion;
    }

    public SendStatistics getSendStatistics() {
        return this.sendStatistics;
    }

    public Map<String, String> getConfiguration() {
        if (this.configuration == null) {
            return null;
        }
        return new TreeMap<String, String>(this.configuration);
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseFile that = (LicenseFile)o;
        if (this.getProduct() != null ? !this.getProduct().equals(that.getProduct()) : that.getProduct() != null) {
            return false;
        }
        if (this.getLicensee() != null ? !this.getLicensee().equals(that.getLicensee()) : that.getLicensee() != null) {
            return false;
        }
        if (this.getKey() != null ? !this.getKey().equals(that.getKey()) : that.getKey() != null) {
            return false;
        }
        if (this.getCreationDate() != null ? !this.getCreationDate().equals(that.getCreationDate()) : that.getCreationDate() != null) {
            return false;
        }
        if (this.getExpirationDate() != null ? !this.getExpirationDate().equals(that.getExpirationDate()) : that.getExpirationDate() != null) {
            return false;
        }
        if (this.getOnExpiration() != that.getOnExpiration()) {
            return false;
        }
        if (this.getGracePeriod() != null ? !this.getGracePeriod().equals(that.getGracePeriod()) : that.getGracePeriod() != null) {
            return false;
        }
        if (this.getPlatform() != that.getPlatform()) {
            return false;
        }
        if (this.getLicenseType() != that.getLicenseType()) {
            return false;
        }
        if (this.getDeploymentType() != that.getDeploymentType()) {
            return false;
        }
        if (this.getSendStatistics() != that.getSendStatistics()) {
            return false;
        }
        if (this.getProductVersion() != null ? !this.getProductVersion().equals(that.getProductVersion()) : that.getProductVersion() != null) {
            return false;
        }
        if (!MapUtil.equals(this.getLimits(), that.getLimits())) {
            return false;
        }
        if (this.getEventReporting() != null ? !this.getEventReporting().equals(that.getEventReporting()) : that.getEventReporting() != null) {
            return false;
        }
        if (this.getProducerLine() != null ? !this.getProducerLine().equals(that.getProducerLine()) : that.getProducerLine() != null) {
            return false;
        }
        if (this.getComment() != null ? !this.getComment().equals(that.getComment()) : that.getComment() != null) {
            return false;
        }
        if (this.getLicenseVersion() != null ? !this.getLicenseVersion().equals(that.getLicenseVersion()) : that.getLicenseVersion() != null) {
            return false;
        }
        if (!MapUtil.equals(this.getConfiguration(), that.getConfiguration())) {
            return false;
        }
        return this.getSignature() != null ? this.getSignature().equals(that.getSignature()) : that.getSignature() == null;
    }

    public int hashCode() {
        int result = this.getProduct() != null ? this.getProduct().hashCode() : 0;
        result = 31 * result + (this.getLicensee() != null ? this.getLicensee().hashCode() : 0);
        result = 31 * result + (this.getKey() != null ? this.getKey().hashCode() : 0);
        result = 31 * result + (this.getCreationDate() != null ? this.getCreationDate().hashCode() : 0);
        result = 31 * result + (this.getExpirationDate() != null ? this.getExpirationDate().hashCode() : 0);
        result = 31 * result + (this.getOnExpiration() != null ? this.getOnExpiration().hashCode() : 0);
        result = 31 * result + (this.getGracePeriod() != null ? this.getGracePeriod().hashCode() : 0);
        result = 31 * result + (this.getPlatform() != null ? this.getPlatform().hashCode() : 0);
        result = 31 * result + (this.getLicenseType() != null ? this.getLicenseType().hashCode() : 0);
        result = 31 * result + (this.getDeploymentType() != null ? this.getDeploymentType().hashCode() : 0);
        result = 31 * result + (this.getProductVersion() != null ? this.getProductVersion().hashCode() : 0);
        result = 31 * result + (this.getLimits() != null ? MapUtil.getHashCode(this.getLimits()) : 0);
        result = 31 * result + (this.getEventReporting() != null ? this.getEventReporting().hashCode() : 0);
        result = 31 * result + (this.getProducerLine() != null ? this.getProducerLine().hashCode() : 0);
        result = 31 * result + (this.getComment() != null ? this.getComment().hashCode() : 0);
        result = 31 * result + (this.getLicenseVersion() != null ? this.getLicenseVersion().hashCode() : 0);
        result = 31 * result + (this.getConfiguration() != null ? MapUtil.getHashCode(this.getConfiguration()) : 0);
        result = 31 * result + (this.getSendStatistics() != null ? this.getSendStatistics().hashCode() : 0);
        result = 31 * result + (this.getSignature() != null ? this.getSignature().hashCode() : 0);
        return result;
    }

    public LicenseFile copy() {
        return this.copy(true);
    }

    public LicenseFile unsignedCopy() {
        return this.copy(false);
    }

    private LicenseFile copy(boolean signed) {
        TreeMap<String, Limit> copyOfLimits = null;
        if (this.limits != null) {
            copyOfLimits = new TreeMap<String, Limit>();
            for (Map.Entry<String, Limit> entry : this.limits.entrySet()) {
                copyOfLimits.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().copy());
            }
        }
        return new LicenseFile(this.product, this.licensee == null ? null : this.licensee.copy(), this.key, this.creationDate, this.expirationDate, this.onExpiration, this.gracePeriod, this.platform, this.licenseType, this.deploymentType, this.productVersion == null ? null : this.productVersion.copy(), copyOfLimits, this.eventReporting == null ? null : this.eventReporting.copy(), this.producerLine, this.comment, this.licenseVersion, this.configuration, this.sendStatistics, signed ? this.signature : null);
    }
}

