/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote.apigateway;

import com.itextpdf.licensing.remote.PortingUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import com.itextpdf.licensing.remote.auth.AwsSdkCredentialsProvider;
import com.itextpdf.licensing.remote.auth.AwsSign4;
import com.itextpdf.licensing.remote.exceptions.LicenseKeyRemoteException;
import java.util.TreeMap;

public class ApiGatewayClient {
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    private static final String SERVICE_NAME = "execute-api";
    private static final String HTTP_POST_METHOD = "POST";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final AwsSdkCredentialsProvider credentialsProvider;
    private final String host;
    private final String resource;
    private int timeoutMillis = 5000;

    public ApiGatewayClient(String host, String resource) {
        this(host, resource, null);
    }

    public ApiGatewayClient(String host, String resource, AwsSdkCredentialsProvider credentialsProvider) {
        this.host = host;
        this.resource = resource;
        this.credentialsProvider = credentialsProvider;
    }

    public ApiGatewayClient setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public ApiGatewayResponse makePostRequest() {
        return this.makePostRequest("");
    }

    public ApiGatewayResponse makePostRequest(String requestBody) {
        ApiGatewayResponse response;
        boolean didRetriedRequest = false;
        try {
            response = this.tryMakePostRequest(requestBody);
            if (response.getStatus() != 200 && this.credentialsProvider != null) {
                this.credentialsProvider.refresh();
                didRetriedRequest = true;
                response = this.tryMakePostRequest(requestBody);
            }
        }
        catch (Exception e) {
            if (this.credentialsProvider == null || didRetriedRequest) {
                throw e;
            }
            this.credentialsProvider.refresh();
            response = this.tryMakePostRequest(requestBody);
        }
        return response;
    }

    private ApiGatewayResponse tryMakePostRequest(String requestBody) {
        try {
            TreeMap<String, String> headers = new TreeMap<String, String>();
            headers.put(CONTENT_TYPE_HEADER, PortingUtil.getJsonContentTypeHeader());
            if (this.credentialsProvider != null) {
                AwsSign4.applyAwsSign4(this.host, this.resource, HTTP_POST_METHOD, SERVICE_NAME, headers, requestBody, this.credentialsProvider.getCredentialsData());
            }
            return PortingUtil.tryMakePostHttpRequest(requestBody, this.host, this.resource, headers, this.timeoutMillis);
        }
        catch (Exception e) {
            throw new LicenseKeyRemoteException("Exception during http request execution.", e);
        }
    }
}

