/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote.apigateway;

import com.itextpdf.licensing.remote.PortingUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayHttpClientKeeper;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import com.itextpdf.licensing.remote.auth.AwsSdkCredentialsProvider;
import com.itextpdf.licensing.remote.auth.AwsSign4;
import com.itextpdf.licensing.remote.exceptions.LicenseKeyRemoteException;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiGatewayClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiGatewayClient.class);
    private static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    private static final int LOWER_BOUND_OF_SUCCESSFUL_HTTP_CODE = 200;
    private static final int UPPER_BOUND_OF_SUCCESSFUL_HTTP_CODE = 300;
    private static final int MAX_RETRY_ATTEMPTS = 2;
    private static final String SERVICE_NAME = "execute-api";
    private static final String HTTP_POST_METHOD = "POST";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final AwsSdkCredentialsProvider credentialsProvider;
    private final String host;
    private final String resource;
    private int timeoutMillis = 5000;

    public ApiGatewayClient(String host, String resource) {
        this(host, resource, null);
    }

    public ApiGatewayClient(String host, String resource, AwsSdkCredentialsProvider credentialsProvider) {
        this.host = host;
        this.resource = resource;
        this.credentialsProvider = credentialsProvider;
    }

    public ApiGatewayClient setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public ApiGatewayResponse makePostRequest() {
        return this.makePostRequest("");
    }

    public ApiGatewayResponse makePostRequest(String requestBody) {
        boolean credentialsRefreshRequired = this.credentialsProvider != null;
        for (int requestAttempts = 0; requestAttempts < 2; ++requestAttempts) {
            try {
                ApiGatewayResponse response = this.tryMakePostRequest(requestBody);
                int responseStatus = response.getStatus();
                if (200 <= responseStatus && responseStatus < 300) {
                    return response;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (credentialsRefreshRequired) {
                credentialsRefreshRequired = false;
                this.credentialsProvider.refresh();
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Connection problem occurs while requesting. Request will be retried");
        }
        return this.tryMakePostRequest(requestBody);
    }

    private ApiGatewayResponse tryMakePostRequest(String requestBody) {
        try {
            TreeMap<String, String> headers = new TreeMap<String, String>();
            headers.put(CONTENT_TYPE_HEADER, PortingUtil.getJsonContentTypeHeader());
            if (this.credentialsProvider != null) {
                AwsSign4.applyAwsSign4(this.host, this.resource, HTTP_POST_METHOD, SERVICE_NAME, headers, requestBody, this.credentialsProvider.getCredentialsData());
            }
            return ApiGatewayHttpClientKeeper.getApiGatewayHttpClient().tryMakePostHttpRequest(requestBody, this.host, this.resource, headers, this.timeoutMillis);
        }
        catch (Exception e) {
            throw new LicenseKeyRemoteException("Exception during http request execution.", e);
        }
    }
}

