/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.parse;

public class CssDeclarationValueTokenizer {
    protected final String src;
    protected int index = -1;
    protected char stringQuote;
    protected boolean inString;
    protected int functionDepth = 0;

    public CssDeclarationValueTokenizer(String propertyValue) {
        this.src = propertyValue;
    }

    public Token getNextValidToken() {
        Token result;
        Token token = this.getNextToken();
        while (token != null && !token.isString() && token.getValue().trim().isEmpty()) {
            token = this.getNextToken();
        }
        if (token != null && this.functionDepth > 0 && (result = this.parseFunctionToken(token, 0)) != null) {
            return result;
        }
        return token;
    }

    protected Token parseFunctionToken(Token token, int funcDepth) {
        StringBuilder functionBuffer = new StringBuilder();
        while (token != null && this.functionDepth > funcDepth) {
            this.processFunctionToken(token, functionBuffer);
            token = this.getNextToken();
        }
        this.functionDepth = 0;
        if (functionBuffer.length() != 0) {
            if (token != null) {
                this.processFunctionToken(token, functionBuffer);
            }
            return new Token(functionBuffer.toString(), TokenType.FUNCTION);
        }
        return null;
    }

    protected Token getNextToken() {
        StringBuilder buff = new StringBuilder();
        if (this.index >= this.src.length() - 1) {
            return null;
        }
        if (this.inString) {
            boolean isEscaped = false;
            StringBuilder pendingUnicodeSequence = new StringBuilder();
            while (++this.index < this.src.length()) {
                char curChar = this.src.charAt(this.index);
                if (isEscaped) {
                    if (CssDeclarationValueTokenizer.isHexDigit(curChar) && pendingUnicodeSequence.length() < 6) {
                        pendingUnicodeSequence.append(curChar);
                        continue;
                    }
                    if (pendingUnicodeSequence.length() != 0) {
                        int codePoint = Integer.parseInt(pendingUnicodeSequence.toString(), 16);
                        if (Character.isValidCodePoint(codePoint)) {
                            buff.appendCodePoint(codePoint);
                        } else {
                            buff.append("\ufffd");
                        }
                        pendingUnicodeSequence.setLength(0);
                        if (curChar == this.stringQuote) {
                            this.inString = false;
                            return new Token(buff.toString(), TokenType.STRING, this.stringQuote);
                        }
                        if (!Character.isWhitespace(curChar)) {
                            buff.append(curChar);
                        }
                        isEscaped = false;
                        continue;
                    }
                    buff.append(curChar);
                    isEscaped = false;
                    continue;
                }
                if (curChar == this.stringQuote) {
                    this.inString = false;
                    return new Token(buff.toString(), TokenType.STRING, this.stringQuote);
                }
                if (curChar == '\\') {
                    isEscaped = true;
                    continue;
                }
                buff.append(curChar);
            }
        } else {
            while (++this.index < this.src.length()) {
                char curChar = this.src.charAt(this.index);
                if (curChar == '(') {
                    ++this.functionDepth;
                    buff.append(curChar);
                    continue;
                }
                if (curChar == ')') {
                    --this.functionDepth;
                    buff.append(curChar);
                    if (this.functionDepth != 0) continue;
                    return new Token(buff.toString(), TokenType.FUNCTION, '\u0000', this.isSpaceNext());
                }
                if (curChar == '\"' || curChar == '\'') {
                    this.stringQuote = curChar;
                    this.inString = true;
                    return new Token(buff.toString(), TokenType.FUNCTION);
                }
                if (curChar == '[') {
                    this.stringQuote = '\u0000';
                    this.inString = true;
                    buff.append(curChar);
                    continue;
                }
                if (curChar == ']') {
                    this.inString = false;
                    buff.append(curChar);
                    return new Token(buff.toString(), TokenType.STRING, '\u0000', this.isSpaceNext());
                }
                if (curChar == ',' && !this.inString && this.functionDepth == 0) {
                    if (buff.length() == 0) {
                        return new Token(",", TokenType.COMMA);
                    }
                    --this.index;
                    return new Token(buff.toString(), TokenType.UNKNOWN);
                }
                if (Character.isWhitespace(curChar)) {
                    if (this.functionDepth > 0 || this.inString) {
                        buff.append(curChar);
                    }
                    if (this.inString) continue;
                    return new Token(buff.toString(), this.functionDepth > 0 ? TokenType.FUNCTION : TokenType.UNKNOWN, '\u0000', true);
                }
                buff.append(curChar);
            }
        }
        return new Token(buff.toString(), TokenType.FUNCTION);
    }

    private boolean isSpaceNext() {
        return this.src.length() - 1 > this.index && this.src.charAt(this.index + 1) == ' ';
    }

    private void processFunctionToken(Token token, StringBuilder functionBuffer) {
        if (token.isString()) {
            if (this.stringQuote != '\u0000' && token.getStringQuote() != '\u0000') {
                functionBuffer.append(this.stringQuote);
            }
            functionBuffer.append(token.getValue());
            if (this.stringQuote != '\u0000' && token.getStringQuote() != '\u0000') {
                functionBuffer.append(this.stringQuote);
            }
        } else {
            functionBuffer.append(token.getValue());
        }
    }

    private static boolean isHexDigit(char c) {
        return '/' < c && c < ':' || '@' < c && c < 'G' || '`' < c && c < 'g';
    }

    public static enum TokenType {
        STRING,
        FUNCTION,
        COMMA,
        UNKNOWN;

    }

    public static class Token {
        private final String value;
        private final TokenType type;
        private final char stringQuote;
        private final boolean hasSpace;

        public Token(String value, TokenType type) {
            this(value, type, '\u0000', false);
        }

        Token(String value, TokenType type, char stringQuote) {
            this(value, type, stringQuote, false);
        }

        Token(String value, TokenType type, char stringQuote, boolean hasSpace) {
            this.value = value;
            this.type = type;
            this.stringQuote = stringQuote;
            this.hasSpace = hasSpace;
        }

        public String getValue() {
            return this.value;
        }

        public TokenType getType() {
            return this.type;
        }

        public char getStringQuote() {
            return this.stringQuote;
        }

        public boolean hasSpace() {
            return this.hasSpace;
        }

        public boolean isString() {
            return this.type == TokenType.STRING;
        }

        public String toString() {
            return this.value;
        }
    }
}

