/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.wsdl.metadataModel;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.XmlMetaDataNamespaceManager;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.DefaultXmlMetaDataBuilder;
import org.mule.common.metadata.builder.MetaDataBuilder;
import org.mule.common.metadata.builder.XmlMetaDataBuilder;
import org.mule.common.metadata.property.DescriptionMetaDataProperty;
import org.mule.common.metadata.property.LabelMetaDataProperty;
import org.mule.common.metadata.property.TextBasedExampleMetaDataModelProperty;
import org.mule.common.metadata.property.xml.XsiTypeMetaDataProperty;
import org.mule.modules.wsdl.metadataModel.ConcreteXmlMetaDataModel;

public class ConcreteTypeXmlMetadataBuilder<P extends MetaDataBuilder<MetaDataModel>>
extends DefaultXmlMetaDataBuilder<P> {
    private XmlMetaDataBuilder<P> defaultBehavior;
    private String label;
    private String description;
    private URL sourceUrl;
    private String concreteType;
    private XmlMetaDataNamespaceManager namespaceManager = new XmlMetaDataNamespaceManager();

    public ConcreteTypeXmlMetadataBuilder(QName elementType) {
        super(elementType);
        this.defaultBehavior = new DefaultMetaDataBuilder().createXmlObject(elementType);
    }

    public ConcreteTypeXmlMetadataBuilder withConcreteType(String concreteType) {
        this.concreteType = concreteType;
        return this;
    }

    public XmlMetaDataModel build() {
        return this.concreteType == null ? (XmlMetaDataModel)this.defaultBehavior.build() : this.concreteBuild();
    }

    private XmlMetaDataModel concreteBuild() {
        ConcreteXmlMetaDataModel model = null;
        if (this.schemasStream != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (InputStream schemaStream : this.schemasStream) {
                result.add(ConcreteTypeXmlMetadataBuilder.getStringFromInputStream(schemaStream, this.encoding));
            }
            this.schemas = result;
        }
        if (this.type == null) {
            if (this.schemas == null) {
                if (this.schemasUrls != null) {
                    model = new ConcreteXmlMetaDataModel(this.schemasUrls, this.name, this.namespaceManager, this.concreteType, new MetaDataModelProperty[]{new TextBasedExampleMetaDataModelProperty(this.example)});
                }
            } else {
                model = new ConcreteXmlMetaDataModel((List<String>)this.schemas, this.sourceUrl, this.name, this.encoding, this.namespaceManager, this.concreteType, new MetaDataModelProperty[]{new TextBasedExampleMetaDataModelProperty(this.example)});
            }
        } else if (this.schemas == null) {
            if (this.schemasUrls != null) {
                model = new ConcreteXmlMetaDataModel(this.schemasUrls, this.name, this.namespaceManager, this.concreteType, new MetaDataModelProperty[]{new TextBasedExampleMetaDataModelProperty(this.example)});
            }
        } else {
            model = new ConcreteXmlMetaDataModel((List<String>)this.schemas, this.sourceUrl, this.name, this.type, this.encoding, this.namespaceManager, this.concreteType, new MetaDataModelProperty[]{new TextBasedExampleMetaDataModelProperty(this.example), new XsiTypeMetaDataProperty(this.type)});
        }
        if (model != null) {
            if (this.label != null) {
                model.addProperty((MetaDataModelProperty)new LabelMetaDataProperty(this.label));
            }
            if (this.description != null) {
                model.addProperty((MetaDataModelProperty)new DescriptionMetaDataProperty(this.description));
            }
            if (this.type != null) {
                model.addProperty((MetaDataModelProperty)new XsiTypeMetaDataProperty(this.type));
            }
        }
        return model;
    }

    private static String getStringFromInputStream(InputStream is, Charset encoding) {
        try {
            if (encoding == null) {
                return IOUtils.toString((InputStream)is);
            }
            return IOUtils.toString((InputStream)is, (String)encoding.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to turn input stream into string with encoding [" + encoding + "]", ex);
        }
    }

    public DefaultXmlMetaDataBuilder<P> setSourceUri(URL sourceUrl) {
        this.sourceUrl = sourceUrl;
        return super.setSourceUri(sourceUrl);
    }

    public DefaultXmlMetaDataBuilder<P> addSchemaStringList(String ... schemas) {
        this.defaultBehavior.addSchemaStringList(schemas);
        return super.addSchemaStringList(schemas);
    }

    public DefaultXmlMetaDataBuilder<P> addSchemaStreamList(InputStream ... schemaStreams) {
        this.defaultBehavior.addSchemaStreamList(schemaStreams);
        return super.addSchemaStreamList(schemaStreams);
    }

    public DefaultXmlMetaDataBuilder<P> addSchemaUrlList(URL ... schemaStreams) {
        this.defaultBehavior.addSchemaUrlList(schemaStreams);
        return super.addSchemaUrlList(schemaStreams);
    }

    public DefaultXmlMetaDataBuilder<P> setEncoding(Charset encoding) {
        this.defaultBehavior.setEncoding(encoding);
        return super.setEncoding(encoding);
    }

    public DefaultXmlMetaDataBuilder<P> setExample(String xmlExample) {
        this.defaultBehavior.setExample(xmlExample);
        return super.setExample(xmlExample);
    }

    public DefaultXmlMetaDataBuilder<P> setLabel(String label) {
        this.defaultBehavior.setLabel(label);
        return super.setLabel(label);
    }

    public DefaultXmlMetaDataBuilder<P> setDescription(String description) {
        this.defaultBehavior.setDescription(description);
        return super.setDescription(description);
    }

    public DefaultXmlMetaDataBuilder<P> setType(QName qName) {
        this.defaultBehavior.setType(qName);
        return super.setType(qName);
    }
}

