/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.internal.matchers;

import com.google.common.collect.Lists;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mule.munit.assertion.internal.matchers.ValueMatcher;
import org.mule.runtime.api.metadata.TypedValue;

public class IterableMatcher
extends ValueMatcher {
    private TypedValue valueToBeMatched;

    public IterableMatcher(Matcher<? extends Iterable<?>> nestedMatcher) {
        super(nestedMatcher);
    }

    @Override
    public boolean doMatch(TypedValue typedValue) {
        this.valueToBeMatched = this.escapeIterator(typedValue);
        return super.doMatch(this.valueToBeMatched);
    }

    @Override
    public void describeMismatch(Object item, Description description) {
        super.describeMismatch(this.valueToBeMatched, description);
    }

    private TypedValue escapeIterator(TypedValue typedValue) {
        if (!(typedValue.getValue() instanceof Iterator)) {
            return typedValue;
        }
        Iterator iterator = (Iterator)typedValue.getValue();
        return TypedValue.of((Object)Lists.newArrayList((Iterator)iterator));
    }
}

