/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.core;

import com.newrelic.logging.core.LogExtensionConfig;

public class ExceptionUtil {
    public static final int MAX_STACK_SIZE_DEFAULT = 300;

    public static String getErrorStack(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StackTraceElement[] stack = throwable.getStackTrace();
        return ExceptionUtil.getErrorStack(stack);
    }

    public static String getErrorStack(StackTraceElement[] stack) {
        return ExceptionUtil.getErrorStack(stack, LogExtensionConfig.getMaxStackSize());
    }

    public static String getErrorStack(StackTraceElement[] stack, Integer maxStackSize) {
        if (stack == null || stack.length == 0) {
            return null;
        }
        StringBuilder stackBuilder = new StringBuilder();
        for (int i = 0; i < Math.min(maxStackSize, stack.length); ++i) {
            stackBuilder.append("  at ").append(stack[i].toString()).append("\n");
        }
        return stackBuilder.toString();
    }
}

