/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.core;

public class LogExtensionConfig {
    public static final String CONTEXT_PREFIX = "context.";
    private static final String CONFIG_PREFIX_ENV_VAR = "NEW_RELIC_LOG_EXTENSION_";
    private static final String CONFIG_PREFIX_SYS_PROP = "newrelic.log_extension.";
    public static final String MAX_STACK_SIZE_ENV_VAR = "NEW_RELIC_LOG_EXTENSION_MAX_STACK_SIZE";
    public static final String MAX_STACK_SIZE_SYS_PROP = "newrelic.log_extension.max_stack_size";
    public static final String ADD_MDC_ENV_VAR = "NEW_RELIC_LOG_EXTENSION_ADD_MDC";
    public static final String ADD_MDC_SYS_PROP = "newrelic.log_extension.add_mdc";
    public static final boolean ADD_MDC_DEFAULT = false;

    public static int getMaxStackSize() {
        String envVar = System.getenv(MAX_STACK_SIZE_ENV_VAR);
        String sysProp = System.getProperty(MAX_STACK_SIZE_SYS_PROP);
        if (LogExtensionConfig.isInteger(envVar)) {
            return Integer.parseInt(envVar);
        }
        if (LogExtensionConfig.isInteger(sysProp)) {
            return Integer.parseInt(sysProp);
        }
        return 300;
    }

    public static boolean shouldAddMDC() {
        String envVar = System.getenv(ADD_MDC_ENV_VAR);
        String sysProp = System.getProperty(ADD_MDC_SYS_PROP);
        if (envVar != null) {
            return Boolean.parseBoolean(envVar);
        }
        if (sysProp != null) {
            return Boolean.parseBoolean(sysProp);
        }
        return false;
    }

    static boolean isInteger(String val) {
        if (val == null) {
            return false;
        }
        try {
            Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

