/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.jul;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.newrelic.logging.core.ExceptionUtil;
import com.newrelic.logging.jul.NewRelicLogRecord;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class NewRelicFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        StringWriter sw = new StringWriter();
        try (JsonGenerator generator = new JsonFactory().createGenerator((Writer)sw);){
            this.writeToGenerator(record, generator);
        }
        catch (IOException e) {
            return e.toString();
        }
        return sw + "\n";
    }

    private void writeToGenerator(LogRecord record, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeObjectField("message", (Object)this.formatMessage(record));
        generator.writeObjectField("timestamp", (Object)record.getMillis());
        generator.writeObjectField("log.level", (Object)record.getLevel().toString());
        generator.writeObjectField("logger.name", (Object)record.getLoggerName());
        if (record.getSourceClassName() != null && record.getSourceMethodName() != null) {
            generator.writeObjectField("class.name", (Object)record.getSourceClassName());
            generator.writeObjectField("method.name", (Object)record.getSourceMethodName());
        }
        if (record instanceof NewRelicLogRecord) {
            generator.writeObjectField("thread.name", (Object)((NewRelicLogRecord)record).getThreadName());
            Map<String, String> traceData = ((NewRelicLogRecord)record).getTraceData();
            for (Map.Entry<String, String> traceEntry : traceData.entrySet()) {
                generator.writeStringField(traceEntry.getKey(), traceEntry.getValue());
            }
        }
        if (record.getThrown() != null) {
            generator.writeObjectField("error.class", (Object)record.getThrown().getClass().getName());
            generator.writeObjectField("error.message", (Object)record.getThrown().getMessage());
            generator.writeObjectField("error.stack", (Object)ExceptionUtil.getErrorStack(record.getThrown()));
        }
        generator.writeEndObject();
    }
}

