/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.logging.jul;

import com.newrelic.api.agent.Agent;
import com.newrelic.api.agent.NewRelic;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class NewRelicLogRecord
extends LogRecord {
    private final String threadName;
    private final Map<String, String> traceData;
    private static final long serialVersionUID = 53723902839002534L;
    static Supplier<Agent> agentSupplier = NewRelic::getAgent;

    private NewRelicLogRecord(Level level, String msg) {
        this(level, msg, agentSupplier.get().getLinkingMetadata());
    }

    NewRelicLogRecord(Level level, String msg, Map<String, String> traceData) {
        super(level, msg);
        this.traceData = traceData;
        this.threadName = Thread.currentThread().getName();
    }

    NewRelicLogRecord(LogRecord record) {
        this(record.getLevel(), record.getMessage());
        this.setMillis(record.getMillis());
        this.setLoggerName(record.getLoggerName());
        this.setParameters(record.getParameters());
        this.setResourceBundleName(record.getResourceBundleName());
        this.setSourceClassName(record.getSourceClassName());
        this.setSourceMethodName(record.getSourceMethodName());
        this.setThreadID(record.getThreadID());
        this.setThrown(record.getThrown());
    }

    String getThreadName() {
        return this.threadName;
    }

    Map<String, String> getTraceData() {
        return this.traceData;
    }
}

