/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.opera.core.systems.OperaAtom;
import com.opera.core.systems.OperaKeyboard;
import com.opera.core.systems.OperaMouse;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaProfile;
import com.opera.core.systems.OperaProxy;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.OperaTimeouts;
import com.opera.core.systems.OperaUtils;
import com.opera.core.systems.OperaWebElement;
import com.opera.core.systems.RunsSelftest;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.common.io.Closeables;
import com.opera.core.systems.common.lang.OperaStrings;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.model.ScriptResult;
import com.opera.core.systems.preferences.OperaScopePreferences;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.runner.launcher.OperaLauncherRunner;
import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.exceptions.ResponseNotReceivedException;
import com.opera.core.systems.scope.internal.OperaDefaults;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.services.ICookieManager;
import com.opera.core.systems.scope.services.ICoreUtils;
import com.opera.core.systems.scope.services.IEcmaScriptDebugger;
import com.opera.core.systems.scope.services.IOperaExec;
import com.opera.core.systems.scope.services.IWindowManager;
import com.opera.core.systems.scope.services.ums.CoreUtils;
import com.opera.core.systems.scope.services.ums.Selftest;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.RemoteLogs;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Duration;

public class OperaDriver
extends RemoteWebDriver
implements TakesScreenshot,
RunsSelftest {
    protected final OperaSettings settings;
    protected OperaRunner runner = null;
    private ScopeServices services;
    private IEcmaScriptDebugger debugger;
    private IOperaExec exec;
    private IWindowManager windowManager;
    private ICoreUtils coreUtils;
    private ICookieManager cookieManager;
    private OperaScopePreferences preferences;
    private OperaMouse mouse;
    private OperaKeyboard keyboard;
    private OperaProxy proxy;
    protected Set<Integer> objectIds = Sets.newHashSet();
    private int assignedWindowIds = 0;
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected static FileHandler logFile = null;

    public OperaDriver() {
        this(new OperaSettings());
    }

    public OperaDriver(OperaProfile profile) {
        this(new OperaSettings.Builder().usingProfile(profile).get());
    }

    public OperaDriver(Capabilities capabilities) {
        this(new OperaSettings().merge(capabilities));
    }

    public OperaDriver(OperaSettings settings) {
        this.settings = settings;
        this.logger.config(settings.toString());
        this.start();
    }

    private void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            this.quit();
            throw new WebDriverException((Throwable)e);
        }
    }

    protected void init() {
        if (this.settings.autostart()) {
            this.runner = new OperaLauncherRunner(this.settings);
        } else {
            this.settings.setPort(-1);
        }
        this.createScopeServices();
        if (this.runner != null) {
            this.runner.startOpera();
        }
        this.services.init();
        this.debugger = this.services.getDebugger();
        this.debugger.setDriver(this);
        this.windowManager = this.services.getWindowManager();
        this.exec = this.services.getExec();
        this.coreUtils = this.services.getCoreUtils();
        this.cookieManager = this.services.getCookieManager();
        this.preferences = new OperaScopePreferences(this.services.getPrefs());
        this.mouse = new OperaMouse(this);
        this.keyboard = new OperaKeyboard(this);
        this.proxy = new OperaProxy(this);
        this.settings.setProduct(this.utils().getProduct());
        this.preferences().set("User Prefs", "Ignore Unrequested Popups", false);
        this.proxy.parse(this.settings.getProxy());
        if (this.utils().getProduct().is(OperaProduct.MOBILE)) {
            this.preferences().set("User Prefs", "Allow Autofocus Form Element", true);
        }
    }

    protected Map<String, String> getRequiredServices() {
        ImmutableMap.Builder versions = ImmutableMap.builder();
        versions.put((Object)"ecmascript-debugger", (Object)"5.0");
        versions.put((Object)"window-manager", (Object)"2.0");
        versions.put((Object)"exec", (Object)"2.0");
        versions.put((Object)"core", (Object)"1.0");
        versions.put((Object)"cookie-manager", (Object)"1.0");
        versions.put((Object)"prefs", (Object)"1.0");
        versions.put((Object)"selftest", (Object)"1.1");
        return versions.build();
    }

    private void createScopeServices() {
        try {
            this.services = new ScopeServices(this.getRequiredServices(), this.settings.getPort(), !this.settings.autostart());
            this.services.startStpThread();
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    public Capabilities getCapabilities() {
        return this.settings.toCapabilities();
    }

    public void quit() {
        this.gc();
        try {
            block14: {
                if (this.services != null) {
                    if (!this.settings.hasDetach()) {
                        try {
                            if (this.runner != null) {
                                this.services.quit(this.runner);
                                break block14;
                            }
                            this.services.quit();
                        }
                        catch (Exception e) {
                            if (this.runner != null && this.runner.isOperaRunning()) {
                                this.runner.stopOpera();
                                break block14;
                            }
                            Throwables.propagateIfPossible((Throwable)e);
                        }
                    } else {
                        this.services.shutdown();
                    }
                }
            }
            if (this.runner != null) {
                this.runner.shutdown();
            }
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        finally {
            if (!this.settings.hasDetach()) {
                this.settings.profile().cleanUp();
            }
            Closeables.closeQuietly(logFile);
        }
    }

    public void get(String url) {
        this.get(url, OperaIntervals.PAGE_LOAD_TIMEOUT.getMs());
    }

    public int get(String url, long timeout) {
        if (url == null) {
            throw new NullPointerException("Invalid URL");
        }
        if (this.services.getConnection() == null) {
            throw new CommunicationException("Unable to open URL because Opera is not connected");
        }
        this.gc();
        this.exec.releaseKeys();
        int activeWindowId = this.windowManager.getActiveWindowId();
        String oldUrl = this.getCurrentUrl();
        this.services.captureOperaIdle();
        this.windowManager.openUrl(activeWindowId, url);
        if (oldUrl == null || url.replace(oldUrl, "").isEmpty() || url.replace(oldUrl, "").charAt(0) != '#') {
            if (this.settings.useIdle() && this.services.isOperaIdleAvailable()) {
                try {
                    if (timeout == OperaIntervals.PAGE_LOAD_TIMEOUT.getMs()) {
                        timeout = OperaIntervals.OPERA_IDLE_TIMEOUT.getMs();
                    }
                    this.services.waitForOperaIdle(timeout);
                }
                catch (WebDriverException e) {
                    this.logger.warning("idle: Timed out with exception: " + e.getMessage());
                }
            } else {
                try {
                    this.services.waitForWindowLoaded(activeWindowId, timeout);
                }
                catch (ResponseNotReceivedException e) {
                    this.logger.fine("Response not received, returning control to user");
                }
            }
        }
        if (OperaDefaults.ENABLE_DEBUGGER) {
            this.switchTo().defaultContent();
        }
        return this.windowManager.getLastHttpResponseCode().getAndSet(0);
    }

    public String getCurrentUrl() {
        return this.debugger.executeJavascript("return document.location.href");
    }

    public void close() {
        if (!this.getScopeServices().isConnected()) {
            return;
        }
        int windowCountBeforeClose = this.getWindowCount();
        if (windowCountBeforeClose >= 1) {
            this.windowManager.closeWindow(this.windowManager.getActiveWindowId());
        }
        OperaProduct product = this.utils().getProduct();
        if (this.getWindowCount() == 0 || (product.is(OperaProduct.CORE) || product.is(OperaProduct.DESKTOP) && Platform.getCurrent().is(Platform.WINDOWS) || product.is(OperaProduct.MOBILE)) && windowCountBeforeClose == 1) {
            this.quit();
        } else {
            this.windowManager.filterActiveWindow();
        }
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    protected WebElement findElement(final String by, final String using) {
        return this.implicitlyWaitFor(new Callable<WebElement>(){

            @Override
            public WebElement call() {
                return OperaDriver.this.findElement(by, using, null);
            }
        });
    }

    protected WebElement findElement(String by, String using, OperaWebElement el) {
        boolean isAvailable;
        Preconditions.checkNotNull((Object)using, (Object)"Cannot find elements when the selector is null");
        using = OperaStrings.escapeJsString(using);
        String script = el == null ? "return " + (Object)((Object)OperaAtom.FIND_ELEMENT) + "({\"" + by + "\": \"" + using + "\"})" : "return " + (Object)((Object)OperaAtom.FIND_ELEMENT) + "({\"" + by + "\": \"" + using + "\"}, locator)";
        Integer id = el == null ? this.debugger.getObject(script) : this.debugger.executeScriptOnObject(script, el.getObjectId());
        boolean bl = isAvailable = id != null;
        if (isAvailable) {
            String error = this.debugger.callFunctionOnObject("return (locator instanceof Error) ? locator.message : ''", id);
            if (!error.isEmpty()) {
                throw new InvalidSelectorException(error);
            }
            Boolean isStale = Boolean.valueOf(this.debugger.callFunctionOnObject("locator.parentNode == undefined", id));
            if (isStale.booleanValue()) {
                throw new StaleElementReferenceException("This element is no longer part of DOM");
            }
            return new OperaWebElement(this, id);
        }
        throw new NoSuchElementException("Cannot find element(s) with " + by);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    protected List<WebElement> findElements(String by, String using) {
        return this.findElements(by, using, null);
    }

    protected List<WebElement> findElements(String by, String using, OperaWebElement el) {
        List<WebElement> elements;
        Integer id;
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null");
        }
        using = OperaStrings.escapeJsString(using);
        long start = System.currentTimeMillis();
        int count = 0;
        String script = el == null ? "return " + (Object)((Object)OperaAtom.FIND_ELEMENTS) + "({\"" + by + "\": \"" + using + "\"})" : "return " + (Object)((Object)OperaAtom.FIND_ELEMENTS) + "({\"" + by + "\": \"" + using + "\"}, locator)";
        while (true) {
            String error;
            if (!(error = this.debugger.callFunctionOnObject("return (locator instanceof Error) ? locator.message : ''", id = el == null ? this.debugger.getObject(script) : this.debugger.executeScriptOnObject(script, el.getObjectId()))).isEmpty()) {
                throw new InvalidSelectorException(error);
            }
            elements = this.processElements(id);
            if (elements != null) {
                count = elements.size();
            }
            if (count != 0 || !this.hasTimeRemaining(start)) break;
            OperaDriver.sleep(OperaIntervals.IMPLICIT_WAIT.getMs());
        }
        if (id != null) {
            return elements;
        }
        throw new NoSuchElementException("Cannot find element(s) with " + by);
    }

    public String getPageSource() {
        return this.debugger.executeJavascript("return document.documentElement.outerHTML || (typeof window.XMLSerializer != 'undefined') ? (new window.XMLSerializer()).serializeToString(document) : ''");
    }

    public String getTitle() {
        return this.debugger.executeJavascript("return top.document.title ? top.document.title : '';");
    }

    public String getWindowHandle() {
        return this.getWindowHandle(null);
    }

    public Set<String> getWindowHandles() {
        if (!this.services.isConnected()) {
            return ImmutableSet.of();
        }
        List<Integer> windowIds = this.windowManager.getWindowHandles();
        TreeSet<String> handles = new TreeSet<String>();
        if (!OperaDefaults.ENABLE_DEBUGGER) {
            for (Integer windowId : windowIds) {
                handles.add(windowId.toString());
            }
            return handles;
        }
        this.windowManager.clearFilter();
        for (Integer windowId : windowIds) {
            String handleName = this.getWindowHandle(windowId);
            handles.add(handleName);
        }
        this.windowManager.filterActiveWindow();
        this.debugger.resetRuntimesList();
        return handles;
    }

    private String getWindowHandle(Integer windowId) {
        String script = "return top.window.name;";
        String windowName = windowId == null ? this.debugger.executeJavascript(script) : this.debugger.executeJavascript(script, windowId);
        if (windowName.isEmpty()) {
            windowName = "operadriver-window" + this.assignedWindowIds++;
            script = "top.window.name = '" + windowName + "';";
            windowName = windowId == null ? this.debugger.executeJavascript(script) : this.debugger.executeJavascript(script, windowId);
        }
        return windowName;
    }

    public int getWindowCount() {
        return this.windowManager.getWindowHandles().size();
    }

    public WebDriver.TargetLocator switchTo() {
        return new OperaTargetLocator();
    }

    public WebElement findElementByName(String using) {
        return this.findSingleElement("document.getElementsByName('" + OperaStrings.escapeJsString(using, "'") + "')[0];", "name");
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findMultipleElements("document.getElementsByName('" + OperaStrings.escapeJsString(using, "'") + "');", "name");
    }

    public WebDriver.Navigation navigate() {
        return new OperaNavigation();
    }

    public OperaOptions manage() {
        return new OperaOptions();
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        OperaWebElement body = (OperaWebElement)this.findElementByTagName("body");
        return (X)target.convertFromPngBytes(body.saveScreenshot(0L, new String[0]).getPng());
    }

    public Object executeScript(String script, Object ... args) {
        Object object = this.debugger.scriptExecutor(script, args);
        if (object instanceof ScriptResult) {
            ScriptResult result = (ScriptResult)object;
            Integer objectId = result.getObjectId();
            if (objectId == null) {
                return null;
            }
            if (result.getClassName().endsWith("Element")) {
                return new OperaWebElement(this, objectId);
            }
            if (result.getClassName().equals("NodeList")) {
                return this.processElements(objectId);
            }
            if (result.getClassName().equals("Array") || result.getClassName().equals("Object")) {
                return this.debugger.examineScriptResult(objectId);
            }
        }
        return object;
    }

    public Object executeAsyncScript(String script, Object ... args) {
        throw new UnsupportedOperationException();
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    public OperaProxy proxy() {
        return this.proxy;
    }

    public List<String> listFrames() {
        return this.debugger.listFramePaths();
    }

    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) {
        return this.runner.saveScreenshot(timeout, hashes);
    }

    public OperaScopePreferences preferences() {
        return this.preferences;
    }

    public OperaUtils utils() {
        return new OperaUtils(){

            @Override
            public String getCoreVersion() {
                return OperaDriver.this.coreUtils.getCoreVersion();
            }

            @Override
            public Platform getPlatform() {
                return Platform.extractFromSysProperty((String)OperaDriver.this.coreUtils.getOperatingSystem());
            }

            @Override
            public OperaProduct getProduct() {
                return OperaProduct.get(OperaDriver.this.coreUtils.getProduct());
            }

            @Override
            public String getBinaryPath() {
                return OperaDriver.this.coreUtils.getBinaryPath();
            }

            @Override
            public String getUserAgent() {
                return OperaDriver.this.coreUtils.getUserAgent();
            }

            @Override
            public Integer getPID() {
                return OperaDriver.this.coreUtils.getProcessID();
            }

            @Override
            public void clearPrivateData(PrivateData ... flags) {
                ((CoreUtils)OperaDriver.this.coreUtils).clearPrivateData(flags);
            }
        };
    }

    @Override
    public List<Selftest.SelftestResult> selftest(String module) {
        return this.services.selftest((List<String>)ImmutableList.of((Object)module), OperaIntervals.SELFTEST_TIMEOUT.getMs());
    }

    @Deprecated
    public void operaAction(String using, String ... params) {
        this.exec.action(using, params);
    }

    @Deprecated
    public Set<String> getOperaActionList() {
        return this.exec.getActionList();
    }

    protected IEcmaScriptDebugger getScriptDebugger() {
        return this.debugger;
    }

    protected IOperaExec getExecService() {
        return this.exec;
    }

    protected ScopeServices getScopeServices() {
        return this.services;
    }

    protected List<WebElement> processElements(Integer id) {
        List<Integer> ids = this.debugger.examineObjects(id);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        for (Integer objectId : ids) {
            toReturn.add((WebElement)new OperaWebElement(this, objectId));
        }
        return toReturn;
    }

    protected void waitForLoadToComplete() throws ResponseNotReceivedException {
        if (this.settings.useIdle() && this.services.isOperaIdleAvailable()) {
            this.services.waitForOperaIdle(OperaIntervals.OPERA_IDLE_TIMEOUT.getMs());
        } else {
            OperaDriver.sleep(5L);
            long endTime = System.currentTimeMillis() + OperaIntervals.PAGE_LOAD_TIMEOUT.getMs();
            while (!"complete".equals(this.debugger.executeJavascript("return document.readyState"))) {
                if (System.currentTimeMillis() < endTime) {
                    OperaDriver.sleep(OperaIntervals.POLL_INTERVAL.getMs());
                    continue;
                }
                throw new ResponseNotReceivedException("No response in a timely fashion");
            }
        }
    }

    protected <X> X implicitlyWaitFor(Callable<X> condition) {
        long end = System.currentTimeMillis() + OperaIntervals.IMPLICIT_WAIT.getMs();
        Exception lastException = null;
        do {
            X toReturn = null;
            try {
                toReturn = condition.call();
            }
            catch (Exception e) {
                lastException = e;
            }
            if (toReturn instanceof Boolean && !((Boolean)toReturn).booleanValue()) continue;
            if (toReturn != null) {
                return toReturn;
            }
            OperaDriver.sleep(OperaIntervals.POLL_INTERVAL.getMs());
        } while (System.currentTimeMillis() < end);
        if (lastException != null) {
            if (lastException instanceof RuntimeException) {
                throw (RuntimeException)lastException;
            }
            throw new WebDriverException((Throwable)lastException);
        }
        return null;
    }

    protected void setUseOperaIdle(boolean enabled) {
        this.settings.setIdle(enabled);
    }

    protected static void setLogFile(FileHandler log) {
        logFile = log;
    }

    private boolean hasTimeRemaining(long start) {
        return System.currentTimeMillis() - start < OperaIntervals.IMPLICIT_WAIT.getMs();
    }

    private void gc() {
        if (this.services != null && this.services.isConnected() && this.debugger != null) {
            this.debugger.releaseObjects();
        }
        this.objectIds.clear();
    }

    private WebElement findActiveElement() {
        return this.findSingleElement("document.activeElement;", "active element");
    }

    private List<WebElement> findMultipleElements(String script, String type) {
        Integer id;
        List<WebElement> elements;
        long start = System.currentTimeMillis();
        int count = 0;
        while (true) {
            if ((elements = this.processElements(id = this.debugger.getObject(script))) != null) {
                count = elements.size();
            }
            if (count != 0 || !this.hasTimeRemaining(start)) break;
            OperaDriver.sleep(OperaIntervals.POLL_INTERVAL.getMs());
        }
        if (id != null) {
            return elements;
        }
        throw new NoSuchElementException("Cannot find element(s) with " + type);
    }

    private WebElement findSingleElement(String script, String type) {
        Integer id;
        boolean isAvailable;
        long start = System.currentTimeMillis();
        do {
            boolean bl = isAvailable = (id = this.debugger.getObject(script)) != null;
            if (isAvailable) continue;
            OperaDriver.sleep(OperaIntervals.POLL_INTERVAL.getMs());
        } while (!isAvailable && this.hasTimeRemaining(start));
        if (isAvailable) {
            Boolean isStale = Boolean.valueOf(this.debugger.callFunctionOnObject("locator.parentNode == undefined", id));
            if (isStale.booleanValue()) {
                throw new StaleElementReferenceException("This element is no longer part of DOM");
            }
            return new OperaWebElement(this, id);
        }
        throw new NoSuchElementException("Cannot find element(s) with " + type);
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public class OperaOptions
    implements WebDriver.Options {
        public void addCookie(Cookie cookie) {
            if (cookie.getExpiry() == null) {
                cookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), new Date(new Date().getTime() + 1827387392L), false);
            }
            OperaDriver.this.debugger.executeJavascript("document.cookie='" + cookie.toString() + "'", false);
        }

        public void deleteCookieNamed(String name) {
            Cookie cookie = this.getCookieNamed(name);
            this.deleteCookie(cookie);
        }

        public void deleteCookie(Cookie cookie) {
            if (OperaDriver.this.cookieManager == null) {
                throw new UnsupportedOperationException("Deleting cookies are not supported without the cookie-manager service");
            }
            OperaDriver.this.cookieManager.removeCookie(cookie.getDomain(), cookie.getPath(), cookie.getName());
            OperaDriver.this.gc();
        }

        public void deleteAllCookies() {
            if (OperaDriver.this.cookieManager == null) {
                throw new UnsupportedOperationException("Deleting cookies are not supported without the cookie-manager service");
            }
            OperaDriver.this.cookieManager.removeAllCookies();
        }

        public Set<Cookie> getCookies() {
            if (OperaDriver.this.cookieManager == null) {
                throw new UnsupportedOperationException("Setting cookies are not supported without the cookie-manager service");
            }
            return OperaDriver.this.cookieManager.getCookie(OperaDriver.this.debugger.executeJavascript("window.location.hostname"), null);
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            return null;
        }

        public OperaTimeouts timeouts() {
            return new OperaTimeouts(){

                public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
                    OperaIntervals.IMPLICIT_WAIT.setValue(new Duration(time, unit));
                    return this;
                }

                public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
                    OperaIntervals.SCRIPT_TIMEOUT.setValue(new Duration(time, unit));
                    return this;
                }

                public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
                    OperaIntervals.PAGE_LOAD_TIMEOUT.setValue(new Duration(time, unit));
                    return this;
                }

                @Override
                public WebDriver.Timeouts responseTimeout(long time, TimeUnit unit) {
                    OperaIntervals.RESPONSE_TIMEOUT.setValue(new Duration(time, unit));
                    return this;
                }

                @Override
                public WebDriver.Timeouts selftestTimeout(long time, TimeUnit unit) {
                    OperaIntervals.SELFTEST_TIMEOUT.setValue(new Duration(time, unit));
                    return this;
                }
            };
        }

        public WebDriver.ImeHandler ime() {
            throw new UnsupportedOperationException("Not supported in OperaDriver yet");
        }

        @Beta
        public WebDriver.Window window() {
            throw new UnsupportedOperationException("Not supported in OperaDriver yet");
        }

        @Beta
        public Logs logs() {
            return new RemoteLogs(OperaDriver.this.getExecuteMethod(), LocalLogs.NULL_LOGGER);
        }
    }

    private class OperaNavigation
    implements WebDriver.Navigation {
        private OperaNavigation() {
        }

        public void back() {
            OperaDriver.this.services.captureOperaIdle();
            OperaDriver.this.exec.action("Back", new String[0]);
            try {
                OperaDriver.this.waitForLoadToComplete();
            }
            catch (ResponseNotReceivedException e) {
                OperaDriver.this.logger.fine("Response not received, returning control to user");
            }
        }

        public void forward() {
            OperaDriver.this.services.captureOperaIdle();
            OperaDriver.this.exec.action("Forward", new String[0]);
            try {
                OperaDriver.this.waitForLoadToComplete();
            }
            catch (ResponseNotReceivedException e) {
                OperaDriver.this.logger.fine("Response not received, returning control to user");
            }
        }

        public void to(String url) {
            OperaDriver.this.get(url);
        }

        public void to(URL url) {
            OperaDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            OperaDriver.this.services.captureOperaIdle();
            OperaDriver.this.exec.action("Reload", new String[0]);
            try {
                OperaDriver.this.waitForLoadToComplete();
            }
            catch (ResponseNotReceivedException e) {
                OperaDriver.this.logger.fine("Response not received, returning control to user");
            }
        }
    }

    private class OperaTargetLocator
    implements WebDriver.TargetLocator {
        private OperaTargetLocator() {
        }

        public WebElement activeElement() {
            return OperaDriver.this.findActiveElement();
        }

        public WebDriver defaultContent() {
            OperaDriver.this.windowManager.filterActiveWindow();
            OperaDriver.this.debugger.resetFramePath();
            return OperaDriver.this;
        }

        public WebDriver frame(int frameIndex) {
            int framesLength = Integer.valueOf(OperaDriver.this.debugger.executeJavascript("return document.frames.length"));
            if (frameIndex < 0 || frameIndex >= framesLength) {
                throw new NoSuchFrameException("Invalid frame index: " + frameIndex);
            }
            OperaDriver.this.debugger.changeRuntime(frameIndex);
            return OperaDriver.this;
        }

        public WebDriver frame(String frameName) {
            OperaDriver.this.debugger.changeRuntime(frameName);
            return OperaDriver.this;
        }

        public WebDriver window(String windowName) {
            OperaDriver.this.windowManager.clearFilter();
            List<Integer> windowIds = OperaDriver.this.windowManager.getWindowHandles();
            Integer id = 0;
            for (Integer windowId : windowIds) {
                String name = OperaDriver.this.debugger.executeJavascript("return top.window.name || top.document.title || null", windowId);
                if (name == null || !name.equals(windowName)) continue;
                id = windowId;
                break;
            }
            if (id == 0) {
                throw new NoSuchWindowException("Window with name " + windowName + " not found");
            }
            OperaDriver.this.windowManager.setActiveWindowId(id);
            OperaDriver.this.windowManager.filterActiveWindow();
            OperaDriver.this.debugger.resetRuntimesList();
            this.defaultContent();
            OperaDriver.this.debugger.executeJavascript("window.focus()", false);
            return OperaDriver.this;
        }

        public WebDriver frame(WebElement frameElement) {
            String script = "return " + (Object)((Object)OperaAtom.GET_FRAME_INDEX) + "(locator)";
            while (frameElement instanceof WrapsElement) {
                frameElement = ((WrapsElement)frameElement).getWrappedElement();
            }
            Long frameIndex = (Long)OperaDriver.this.debugger.callFunctionOnObject(script, ((OperaWebElement)frameElement).getObjectId(), true);
            if (frameIndex == null) {
                throw new NoSuchFrameException("Non-frame element or frame not in current DOM");
            }
            OperaDriver.this.debugger.changeRuntime(frameIndex.intValue());
            return OperaDriver.this;
        }

        public Alert alert() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum PrivateData {
        ALL,
        VISITED_LINKS,
        DISK_CACHE,
        IMAGE_CACHE,
        MEMORY_CACHE,
        SENSITIVE_DATA,
        SESSION_COOKIES,
        ALL_COOKIES,
        GLOBAL_HISTORY,
        CONSOLE,
        THUMBNAILS,
        WEBDATABASES,
        WEBSTORAGE,
        APPCACHE,
        GEOLOCATION_PERMISSIONS,
        SITE_PREFS;

    }
}

