/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner;

import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.runner.OperaRunnerException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openqa.selenium.os.CommandLine;

public class OperaRunner
implements com.opera.core.systems.runner.interfaces.OperaRunner {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final OperaSettings settings;
    private final ReentrantLock lock = new ReentrantLock();
    private CommandLine process = null;

    public OperaRunner() {
        this(new OperaSettings());
    }

    public OperaRunner(OperaSettings s) {
        this.settings = s;
        if (this.settings.supportsPd()) {
            this.settings.arguments().add("-pd", this.settings.profile().getDirectory().getAbsolutePath());
        }
        if (this.settings.supportsDebugProxy()) {
            this.settings.arguments().add("debugproxy", this.settings.getHost() + ":" + this.settings.getPort());
        }
        this.settings.arguments().add("autotestmode");
        this.logger.config("Opera arguments: " + this.settings.arguments().getArgumentsAsStringList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startOpera() throws OperaRunnerException {
        this.lock.lock();
        List<String> arguments = this.settings.arguments().getArgumentsAsStringList();
        try {
            if (this.process != null) {
                return;
            }
            this.process = new CommandLine(this.settings.getBinary().getPath(), arguments.toArray(new String[arguments.size()]));
            this.process.copyOutputTo((OutputStream)System.err);
            this.process.executeAsync();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopOpera() throws OperaRunnerException {
        this.lock.lock();
        try {
            if (this.process == null) {
                return;
            }
            this.process.destroy();
        }
        finally {
            this.lock.unlock();
            this.process = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOperaRunning() {
        this.lock.lock();
        try {
            if (this.process == null) {
                boolean bl = false;
                return bl;
            }
            this.process.destroy();
            boolean bl = false;
            return bl;
        }
        catch (IllegalThreadStateException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasOperaCrashed() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String getOperaCrashlog() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void shutdown() {
    }

    @Override
    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) {
        throw new UnsupportedOperationException("not implemented");
    }
}

