/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.model.ICommand;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ESCommand implements ICommand
{
    LIST_RUNTIMES(1),
    EVAL(2),
    EXAMINE_OBJECTS(3),
    RELEASE_OBJECTS(4),
    ON_READY_STATE_CHANGED(5),
    DEFAULT(-1);

    private int code;
    private static final Map<Integer, ESCommand> lookup;

    private ESCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    public static ESCommand get(int code) {
        ESCommand command = lookup.get(code);
        if (command == null) {
            return DEFAULT;
        }
        return command;
    }

    @Override
    public String getServiceName() {
        return "ecmascript";
    }

    static {
        lookup = new HashMap<Integer, ESCommand>();
        for (ESCommand command : EnumSet.allOf(ESCommand.class)) {
            lookup.put(command.getCommandID(), command);
        }
    }
}

