/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.SelftestCommand;
import com.opera.core.systems.scope.protos.SelftestProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.ISelftest;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Selftest
extends AbstractService
implements ISelftest {
    public static final String SERVICE_NAME = "selftest";
    private static Pattern errorPattern = Pattern.compile("Warning: Pattern '([^']+)' did not match any tests\nWarning: There is no module named '([^']+)'\n");
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Selftest(ScopeServices services, String version) {
        super(services, version);
        if (!this.isVersionInRange(version, "2.0", SERVICE_NAME)) {
            this.logger.info(String.format("%s version %s is not supported", SERVICE_NAME, version));
        }
        services.setSelftest(this);
    }

    @Override
    public void runSelftests(List<String> modules) {
        this.logger.finest(String.format("runSelftests: %s", modules));
        SelftestProtos.RunModulesArg.Builder builder = SelftestProtos.RunModulesArg.newBuilder();
        builder.addAllModuleList(modules);
        builder.setOutputType(SelftestProtos.RunModulesArg.OutputType.MACHINE_READABLE);
        UmsProtos.Response response = this.executeCommand(SelftestCommand.RUN_MODULES, (AbstractMessage.Builder<?>)builder);
        this.logger.finest(String.format("Selftest response: %s", response));
    }

    public static List<SelftestResult> parseSelftests(String output) {
        String[] lines;
        ImmutableList.Builder results = ImmutableList.builder();
        Matcher matcher = errorPattern.matcher(output);
        if (matcher.matches()) {
            return null;
        }
        for (String line : lines = output.split("\\n")) {
            ISelftest.ResultType result;
            String[] pieces = line.split("\\t");
            String tagAndDescription = pieces[0];
            String resultString = pieces[1];
            String more = pieces.length > 2 ? pieces[2] : null;
            String[] otherPieces = tagAndDescription.split(":", 2);
            String tag = otherPieces[0];
            String description = otherPieces[1];
            if ("PASS".equals(resultString)) {
                result = ISelftest.ResultType.PASS;
            } else if ("FAIL".equals(resultString)) {
                result = ISelftest.ResultType.FAIL;
            } else if ("SKIP".equals(resultString)) {
                result = ISelftest.ResultType.SKIP;
            } else {
                throw new RuntimeException(String.format("Unknown test result %s", resultString));
            }
            results.add((Object)new SelftestResult(tag, description, result, more));
        }
        return results.build();
    }

    public static class SelftestResult
    implements ISelftest.ISelftestResult {
        private final String tag;
        private final String description;
        private final ISelftest.ResultType result;
        private final String more;

        public SelftestResult(String tag, String description, ISelftest.ResultType result) {
            this(tag, description, result, null);
        }

        public SelftestResult(String tag, String description, ISelftest.ResultType result, String more) {
            this.tag = tag;
            this.description = description;
            this.result = result;
            this.more = more;
        }

        @Override
        public String getTag() {
            return this.tag;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public ISelftest.ResultType getResult() {
            return this.result;
        }

        @Override
        public String getMore() {
            return this.more;
        }

        public String toString() {
            StringBuilder format = new StringBuilder();
            format.append("%s:%s\t%s");
            if (this.more != null) {
                format.append("\t%s");
            }
            return String.format(format.toString(), new Object[]{this.tag, this.description, this.result, this.more});
        }

        public boolean equals(Object other) {
            if (!(other instanceof SelftestResult)) {
                return false;
            }
            SelftestResult result = (SelftestResult)other;
            return result.tag.equals(this.tag) && result.description.equals(this.description) && result.result == this.result && (result.more == null || result.more.equals(this.more));
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

