/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.protos.ScopeProtos;
import com.opera.core.systems.scope.services.ICookieManager;
import com.opera.core.systems.scope.services.ICoreUtils;
import com.opera.core.systems.scope.services.IDesktopUtils;
import com.opera.core.systems.scope.services.IDesktopWindowManager;
import com.opera.core.systems.scope.services.IEcmaScriptDebugger;
import com.opera.core.systems.scope.services.IOperaExec;
import com.opera.core.systems.scope.services.IPrefs;
import com.opera.core.systems.scope.services.ISelftest;
import com.opera.core.systems.scope.services.IWindowManager;
import com.opera.core.systems.scope.services.ums.CookieManager;
import com.opera.core.systems.scope.services.ums.CoreUtils;
import com.opera.core.systems.scope.services.ums.DesktopUtils;
import com.opera.core.systems.scope.services.ums.DesktopWindowManager;
import com.opera.core.systems.scope.services.ums.EcmaScriptDebugger;
import com.opera.core.systems.scope.services.ums.EcmaScriptDebugger6;
import com.opera.core.systems.scope.services.ums.EcmascriptService;
import com.opera.core.systems.scope.services.ums.OperaExec;
import com.opera.core.systems.scope.services.ums.Prefs;
import com.opera.core.systems.scope.services.ums.Selftest;
import com.opera.core.systems.scope.services.ums.SystemInputManager;
import com.opera.core.systems.scope.services.ums.WindowManager;
import com.opera.core.systems.util.VersionUtil;
import java.util.List;
import java.util.logging.Logger;

public class UmsServices {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final IEcmaScriptDebugger debugger;
    protected final IOperaExec exec;
    protected final IWindowManager windowManager;
    protected final ICoreUtils coreUtils;
    protected final IDesktopWindowManager desktopWindowManager;
    protected final IDesktopUtils desktopUtils;
    protected final ISelftest selftest;
    protected final SystemInputManager systemInputManager;
    protected final IPrefs prefs;
    private final ICookieManager cookieManager;

    public UmsServices(ScopeServices services, ScopeProtos.HostInfo info) {
        List<ScopeProtos.Service> serviceList = info.getServiceListList();
        this.windowManager = new WindowManager(services, this.getVersionForService(serviceList, "window-manager"));
        this.prefs = this.findServiceNamed(serviceList, "prefs") != null && services.getVersions().containsKey("prefs") ? new Prefs(services, this.getVersionForService(serviceList, "prefs")) : null;
        this.coreUtils = this.findServiceNamed(serviceList, "core") != null && services.getVersions().containsKey("core") ? new CoreUtils(services, this.getVersionForService(serviceList, "core")) : null;
        this.desktopUtils = this.findServiceNamed(serviceList, "desktop-utils") != null && services.getVersions().containsKey("desktop-utils") ? new DesktopUtils(services, this.getVersionForService(serviceList, "desktop-utils")) : null;
        this.systemInputManager = this.findServiceNamed(serviceList, "system-input") != null && services.getVersions().containsKey("system-input") ? new SystemInputManager(services, this.getVersionForService(serviceList, "system-input")) : null;
        this.selftest = this.findServiceNamed(serviceList, "selftest") != null && services.getVersions().containsKey("selftest") ? new Selftest(services, this.getVersionForService(serviceList, "selftest")) : null;
        this.desktopWindowManager = this.findServiceNamed(serviceList, "desktop-window-manager") != null && services.getVersions().containsKey("desktop-window-manager") ? new DesktopWindowManager(this.desktopUtils, this.systemInputManager, services, this.getVersionForService(serviceList, "desktop-window-manager")) : null;
        if (this.findServiceNamed(serviceList, "ecmascript") != null) {
            String ecmascriptVersion = this.getVersionForService(serviceList, "ecmascript");
            this.debugger = new EcmascriptService(services, ecmascriptVersion);
        } else {
            String esdbgVersion = this.getVersionForService(serviceList, "ecmascript-debugger");
            this.debugger = VersionUtil.compare(esdbgVersion, "6.0") >= 0 ? new EcmaScriptDebugger6(services, esdbgVersion) : new EcmaScriptDebugger(services, esdbgVersion);
        }
        this.logger.fine("Using " + this.debugger.getClass().getSimpleName());
        this.exec = new OperaExec(services, this.getVersionForService(serviceList, "exec"));
        this.cookieManager = this.findServiceNamed(serviceList, "cookie-manager") != null && services.getVersions().containsKey("cookie-manager") ? new CookieManager(services, this.getVersionForService(serviceList, "cookie-manager")) : null;
    }

    private String getVersionForService(List<ScopeProtos.Service> serviceList, String name) {
        ScopeProtos.Service service = this.findServiceNamed(serviceList, name);
        if (service != null) {
            return service.getVersion();
        }
        return "0.0";
    }

    private ScopeProtos.Service findServiceNamed(List<ScopeProtos.Service> services, String name) {
        ScopeProtos.Service found = null;
        for (ScopeProtos.Service service : services) {
            if (!service.getName().equals(name)) continue;
            found = service;
            break;
        }
        return found;
    }
}

