/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.util;

import com.google.common.io.Files;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class WatirUtils {
    public static final String ANY_MATCHER = "_ANY_";
    private static final Logger logger = Logger.getLogger(WatirUtils.class.getName());

    public static Integer getSystemDoubleClickTimeMs() {
        Integer DEFAULT_INTERVAL_MS = 500;
        Toolkit t = Toolkit.getDefaultToolkit();
        if (t == null) {
            return DEFAULT_INTERVAL_MS;
        }
        Object o = t.getDesktopProperty("awt.multiClickInterval");
        if (o == null) {
            return DEFAULT_INTERVAL_MS;
        }
        return (Integer)o;
    }

    public static StringBuffer sanitizePath(String input) {
        StringBuffer buf = new StringBuffer();
        if (input.matches("^\".+\"$")) {
            input = input.substring(1, input.length() - 1);
        }
        input = input.replaceAll("\\\\\\\\", "/");
        input = input.replaceAll("\\\\", "/");
        buf.append(input);
        return buf;
    }

    public static boolean copyDirAndFiles(File source, File destination) {
        logger.finest(String.format("WatirUtils::copyDirAndFiles(%s, %s)", source.getAbsolutePath(), destination.getAbsolutePath()));
        if (source.isDirectory()) {
            String[] items;
            for (String item : items = source.list()) {
                File itemDestination;
                File itemSource = new File(source.getPath(), item);
                boolean res = WatirUtils.copyDirAndFiles(itemSource, itemDestination = new File(destination.getPath(), item));
                if (res) continue;
                logger.severe(String.format("Could not copy \"%s\" to \"%s\"", itemSource.getPath(), itemDestination.getPath()));
                return false;
            }
        } else {
            try {
                Files.createParentDirs((File)destination);
                Files.copy((File)source, (File)destination);
            }
            catch (IOException e) {
                logger.severe(String.format("Could not copy files from \"%s\" to \"%s\"", source.getPath(), destination.getPath()));
                return false;
            }
        }
        return true;
    }

    public static boolean textMatchesWithANY(String haystack, String needle) {
        haystack = haystack.trim();
        needle = needle.trim();
        needle = Matcher.quoteReplacement(needle);
        String chars_to_be_escaped = ".|*?+(){}[]^";
        for (char c : chars_to_be_escaped.toCharArray()) {
            String regex = "\\" + c;
            String replacement = "\\\\" + c;
            needle = needle.replaceAll(regex, replacement);
        }
        String pattern = needle.replaceAll(ANY_MATCHER, "(?:.+)");
        logger.finest("Looking for pattern '" + pattern + "' in '" + haystack + "'");
        return haystack.matches(pattern);
    }
}

