/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.oracle.bmc.circuitbreaker.CallNotAllowedException;
import com.oracle.bmc.circuitbreaker.JaxRsCircuitBreaker;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ApacheDuplicatableInputStreamEntity;
import com.oracle.bmc.http.internal.ApacheInputStreamEntity;
import com.oracle.bmc.http.internal.EntityFactory;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.ForwardingInvocationBuilder;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.io.DuplicatableInputStream;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Consumer;
import com.oracle.bmc.util.internal.TransformingFuture;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RestClient.class);
    private static final String PATCH_VERB = "PATCH";
    private final EntityFactory entityFactory;
    private final Client client;
    @VisibleForTesting
    final JaxRsCircuitBreaker circuitBreaker;
    private final boolean isApacheNonBufferingClient;
    private final ClientConfigurator clientConfigurator;
    private WrappedWebTarget baseTarget;

    public RestClient(@NonNull Client client, @NonNull EntityFactory entityFactory, JaxRsCircuitBreaker circuitBreaker) {
        this(client, entityFactory, circuitBreaker, false);
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (entityFactory == null) {
            throw new NullPointerException("entityFactory is marked non-null but is null");
        }
    }

    public RestClient(@NonNull Client client, @NonNull EntityFactory entityFactory, JaxRsCircuitBreaker circuitBreaker, boolean isApacheNonBufferingClient) {
        this(client, entityFactory, circuitBreaker, isApacheNonBufferingClient, null);
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (entityFactory == null) {
            throw new NullPointerException("entityFactory is marked non-null but is null");
        }
    }

    public RestClient(@NonNull Client client, @NonNull EntityFactory entityFactory, JaxRsCircuitBreaker circuitBreaker, boolean isApacheNonBufferingClient, ClientConfigurator clientConfigurator) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (entityFactory == null) {
            throw new NullPointerException("entityFactory is marked non-null but is null");
        }
        this.client = client;
        this.entityFactory = entityFactory;
        this.circuitBreaker = circuitBreaker;
        this.isApacheNonBufferingClient = isApacheNonBufferingClient;
        this.clientConfigurator = clientConfigurator;
    }

    public void setEndpoint(@NonNull String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        this.baseTarget = new WrappedWebTarget(this.client.target(endpoint));
    }

    @Override
    public void close() {
        this.client.close();
    }

    public WrappedWebTarget getBaseTarget() {
        if (this.baseTarget == null) {
            throw new NullPointerException("No endpoint has been configured");
        }
        return this.baseTarget;
    }

    public JaxRsCircuitBreaker getCircuitBreaker() {
        if (this.circuitBreaker == null) {
            throw new NullPointerException("CircuitBreaker has been configured");
        }
        return this.circuitBreaker;
    }

    private Supplier<Response> decorateSupplier(Supplier<Response> supplier) {
        if (this.circuitBreaker == null) {
            return supplier;
        }
        return () -> {
            try {
                return (Response)this.circuitBreaker.decorateSupplier(supplier).get();
            }
            catch (CallNotAllowedException e) {
                throw new BmcException(false, "CircuitBreaker is OPEN!", e, null);
            }
        };
    }

    private Supplier<Future<Response>> decorateFuture(Supplier<Future<Response>> supplier) {
        if (this.circuitBreaker == null) {
            return supplier;
        }
        return () -> {
            try {
                return (Future)this.circuitBreaker.decorateFuture(supplier).get();
            }
            catch (CallNotPermittedException e) {
                throw new BmcException(false, "CircuitBreaker is OPEN!", e, null);
            }
        };
    }

    public <T extends BmcRequest> Response get(@NonNull WrappedInvocationBuilder ib, @NonNull T request) throws BmcException {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        try {
            return this.decorateSupplier(ib::get).get();
        }
        catch (ProcessingException ex) {
            throw RestClient.convertToBmcException(this.baseTarget, ex, info);
        }
    }

    public <T extends BmcRequest> Future<Response> get(@NonNull WrappedInvocationBuilder ib, @NonNull T request, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        if (onSuccess == null && onError == null) {
            return this.decorateFuture(() -> ((AsyncInvoker)ib.async()).get()).get();
        }
        return this.decorateFuture(() -> ib.async().get((InvocationCallback)new Callback(this.baseTarget, info, onSuccess, onError))).get();
    }

    public <B, REQUEST extends BmcRequest<B>, RESPONSE> java.util.function.Function<AsyncHandler<REQUEST, RESPONSE>, Future<RESPONSE>> getFutureSupplier(REQUEST interceptedRequest, WrappedInvocationBuilder ib, Function<Response, RESPONSE> transformer) {
        return h -> {
            SuccessConsumer onSuccess = new SuccessConsumer(h, transformer, interceptedRequest);
            ErrorConsumer<BmcRequest> onError = new ErrorConsumer<BmcRequest>((AsyncHandler<BmcRequest, ?>)h, interceptedRequest);
            Future<Response> responseFuture = this.get(ib, interceptedRequest, onSuccess, onError);
            return new TransformingFuture(responseFuture, transformer);
        };
    }

    public <T extends BmcRequest> Response post(@NonNull WrappedInvocationBuilder ib, @Nullable Object body, @NonNull T request) throws BmcException {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        try {
            Entity<?> requestBody = this.entityFactory.forPost(request, this.attemptToSerialize(request, body));
            return this.decorateSupplier(() -> ib.post(requestBody)).get();
        }
        catch (ProcessingException e) {
            throw RestClient.convertToBmcException(this.baseTarget, e, info);
        }
    }

    public <T extends BmcRequest> Future<Response> post(@NonNull WrappedInvocationBuilder ib, @Nullable Object body, @NonNull T request, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        Entity<?> requestBody = this.entityFactory.forPost(request, this.attemptToSerialize(request, body));
        if (onSuccess == null && onError == null) {
            return this.decorateFuture(() -> ib.async().post(requestBody)).get();
        }
        return this.decorateFuture(() -> ib.async().post(requestBody, (InvocationCallback)new Callback(this.baseTarget, info, onSuccess, onError))).get();
    }

    public <B, REQUEST extends BmcRequest<B>, RESPONSE> java.util.function.Function<AsyncHandler<REQUEST, RESPONSE>, Future<RESPONSE>> postFutureSupplier(REQUEST interceptedRequest, WrappedInvocationBuilder ib, Function<Response, RESPONSE> transformer) {
        return h -> {
            SuccessConsumer onSuccess = new SuccessConsumer(h, transformer, interceptedRequest);
            ErrorConsumer<BmcRequest> onError = new ErrorConsumer<BmcRequest>((AsyncHandler<BmcRequest, ?>)h, interceptedRequest);
            Future<Response> responseFuture = this.post(ib, interceptedRequest.getBody$(), interceptedRequest, onSuccess, onError);
            return new TransformingFuture(responseFuture, transformer);
        };
    }

    public <T extends BmcRequest> Response post(@NonNull WrappedInvocationBuilder ib, @NonNull T request) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.post(ib, null, request);
    }

    public <T extends BmcRequest> Future<Response> post(@NonNull WrappedInvocationBuilder ib, @NonNull T request, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.post(ib, null, request, onSuccess, onError);
    }

    public <T extends BmcRequest> Response patch(@NonNull WrappedInvocationBuilder ib, @NonNull T request) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.patch(ib, null, request);
    }

    public <T extends BmcRequest> Response patch(@NonNull WrappedInvocationBuilder ib, @Nullable Object body, @NonNull T request) throws BmcException {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        try {
            Entity<?> requestBody = this.entityFactory.forPatch(request, this.attemptToSerialize(request, body));
            return this.decorateSupplier(() -> ib.method(PATCH_VERB, requestBody)).get();
        }
        catch (ProcessingException e) {
            throw RestClient.convertToBmcException(this.baseTarget, e, info);
        }
    }

    public <T extends BmcRequest> Future<Response> patch(@NonNull WrappedInvocationBuilder ib, @NonNull T request, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.patch(ib, null, request, onSuccess, onError);
    }

    public <T extends BmcRequest> Future<Response> patch(@NonNull WrappedInvocationBuilder ib, @Nullable Object body, @NonNull T request, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        Entity<?> requestBody = this.entityFactory.forPatch(request, this.attemptToSerialize(request, body));
        if (onSuccess == null && onError == null) {
            return this.decorateFuture(() -> ib.async().method(PATCH_VERB, requestBody)).get();
        }
        return this.decorateFuture(() -> ib.async().method(PATCH_VERB, requestBody, (InvocationCallback)new Callback(this.baseTarget, info, onSuccess, onError))).get();
    }

    public <B, REQUEST extends BmcRequest<B>, RESPONSE> java.util.function.Function<AsyncHandler<REQUEST, RESPONSE>, Future<RESPONSE>> patchFutureSupplier(REQUEST interceptedRequest, WrappedInvocationBuilder ib, Function<Response, RESPONSE> transformer) {
        return h -> {
            SuccessConsumer onSuccess = new SuccessConsumer(h, transformer, interceptedRequest);
            ErrorConsumer<BmcRequest> onError = new ErrorConsumer<BmcRequest>((AsyncHandler<BmcRequest, ?>)h, interceptedRequest);
            Future<Response> responseFuture = this.patch(ib, interceptedRequest.getBody$(), interceptedRequest, onSuccess, onError);
            return new TransformingFuture(responseFuture, transformer);
        };
    }

    public <T extends BmcRequest> Response put(@NonNull WrappedInvocationBuilder ib, @NonNull T request) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.put(ib, null, request);
    }

    public <T extends BmcRequest> Response put(@NonNull WrappedInvocationBuilder ib, @Nullable Object body, @NonNull T request) throws BmcException {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        try {
            Entity<?> requestBody = this.entityFactory.forPut(request, this.attemptToSerialize(request, body));
            return this.decorateSupplier(() -> ib.put(requestBody)).get();
        }
        catch (ProcessingException e) {
            throw RestClient.convertToBmcException(this.baseTarget, e, info);
        }
    }

    public <T extends BmcRequest> Future<Response> put(@NonNull WrappedInvocationBuilder ib, @NonNull T request, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.put(ib, null, request, onSuccess, onError);
    }

    public <T extends BmcRequest> Future<Response> put(@NonNull WrappedInvocationBuilder ib, @Nullable Object body, @NonNull T request, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        Entity<?> requestBody = this.entityFactory.forPut(request, this.attemptToSerialize(request, body));
        if (onSuccess == null && onError == null) {
            return this.decorateFuture(() -> ib.async().put(requestBody)).get();
        }
        return this.decorateFuture(() -> ib.async().put(requestBody, (InvocationCallback)new Callback(this.baseTarget, info, onSuccess, onError))).get();
    }

    public <B, REQUEST extends BmcRequest<B>, RESPONSE> java.util.function.Function<AsyncHandler<REQUEST, RESPONSE>, Future<RESPONSE>> putFutureSupplier(REQUEST interceptedRequest, WrappedInvocationBuilder ib, Function<Response, RESPONSE> transformer) {
        return h -> {
            SuccessConsumer onSuccess = new SuccessConsumer(h, transformer, interceptedRequest);
            ErrorConsumer<BmcRequest> onError = new ErrorConsumer<BmcRequest>((AsyncHandler<BmcRequest, ?>)h, interceptedRequest);
            Future<Response> responseFuture = this.put(ib, interceptedRequest.getBody$(), interceptedRequest, onSuccess, onError);
            return new TransformingFuture(responseFuture, transformer);
        };
    }

    public <T extends BmcRequest> Response delete(@NonNull WrappedInvocationBuilder ib, @NonNull T request) throws BmcException {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        try {
            return this.decorateSupplier(() -> ib.delete(Response.class)).get();
        }
        catch (ProcessingException e) {
            throw RestClient.convertToBmcException(this.baseTarget, e, info);
        }
    }

    public <T extends BmcRequest> Future<Response> delete(@NonNull WrappedInvocationBuilder ib, @NonNull T request, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        if (onSuccess == null && onError == null) {
            return this.decorateFuture(() -> ib.async().delete()).get();
        }
        return this.decorateFuture(() -> ib.async().delete((InvocationCallback)new Callback(this.baseTarget, info, onSuccess, onError))).get();
    }

    public <B, REQUEST extends BmcRequest<B>, RESPONSE> java.util.function.Function<AsyncHandler<REQUEST, RESPONSE>, Future<RESPONSE>> deleteFutureSupplier(REQUEST interceptedRequest, WrappedInvocationBuilder ib, Function<Response, RESPONSE> transformer) {
        return h -> {
            SuccessConsumer onSuccess = new SuccessConsumer(h, transformer, interceptedRequest);
            ErrorConsumer<BmcRequest> onError = new ErrorConsumer<BmcRequest>((AsyncHandler<BmcRequest, ?>)h, interceptedRequest);
            Future<Response> responseFuture = this.delete(ib, interceptedRequest, onSuccess, onError);
            return new TransformingFuture(responseFuture, transformer);
        };
    }

    public <T extends BmcRequest> Response head(@NonNull WrappedInvocationBuilder ib, @NonNull T request) throws BmcException {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        try {
            return this.decorateSupplier(ib::head).get();
        }
        catch (ProcessingException ex) {
            throw RestClient.convertToBmcException(this.baseTarget, ex, info);
        }
    }

    public <T extends BmcRequest> Future<Response> head(@NonNull WrappedInvocationBuilder ib, @NonNull T request, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        InvocationInformation info = RestClient.preprocessRequest(ib, request);
        if (onSuccess == null && onError == null) {
            return this.decorateFuture(() -> ((AsyncInvoker)ib.async()).head()).get();
        }
        return this.decorateFuture(() -> ib.async().head((InvocationCallback)new Callback(this.baseTarget, info, onSuccess, onError))).get();
    }

    public <B, REQUEST extends BmcRequest<B>, RESPONSE> java.util.function.Function<AsyncHandler<REQUEST, RESPONSE>, Future<RESPONSE>> headFutureSupplier(REQUEST interceptedRequest, WrappedInvocationBuilder ib, Function<Response, RESPONSE> transformer) {
        return h -> {
            SuccessConsumer onSuccess = new SuccessConsumer(h, transformer, interceptedRequest);
            ErrorConsumer<BmcRequest> onError = new ErrorConsumer<BmcRequest>((AsyncHandler<BmcRequest, ?>)h, interceptedRequest);
            Future<Response> responseFuture = this.head(ib, interceptedRequest, onSuccess, onError);
            return new TransformingFuture(responseFuture, transformer);
        };
    }

    private static BmcException convertToBmcException(WebTarget target, ProcessingException e, InvocationInformation info) {
        ResponseProcessingException responseProcessingException;
        Response response;
        if (e instanceof ResponseProcessingException && (response = (responseProcessingException = (ResponseProcessingException)e).getResponse()) != null) {
            String statusMessage = response.getStatusInfo() != null ? response.getStatusInfo().getReasonPhrase() : "";
            return new BmcException(response.getStatus(), statusMessage, e.getMessage(), info.getRequestId(), e);
        }
        Throwable t = Throwables.getRootCause((Throwable)e);
        if (t instanceof InterruptedIOException) {
            return new BmcException(true, "Timed out while communicating to: " + target.getUri().toString(), e, info.getRequestId());
        }
        return new BmcException(false, "Processing exception while communicating to: " + target.getUri().toString(), e, info.getRequestId());
    }

    static <T extends BmcRequest> InvocationInformation preprocessRequest(WrappedInvocationBuilder ib, T request) {
        String requestId;
        Object first;
        NonSubmittingInvocationBuilder nonSubmittingInvocationBuilder = new NonSubmittingInvocationBuilder(ib);
        Consumer<Invocation.Builder> invocationPreprocessor = request.getInvocationCallback();
        if (invocationPreprocessor != null) {
            invocationPreprocessor.accept(nonSubmittingInvocationBuilder);
        }
        if ((first = ib.getHeaders().getFirst((Object)"opc-request-id")) == null) {
            requestId = RestClient.generateRequestId();
            LOG.debug("Generated request ID: {} for URI {}", (Object)requestId, (Object)ib.getRequestUri());
            ib.header("opc-request-id", requestId);
        } else {
            requestId = first.toString();
            LOG.debug("User-set request ID: {}", (Object)requestId);
        }
        return new InvocationInformation(requestId, ib.getHeaders());
    }

    private static String generateRequestId() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    private <T extends BmcRequest> Object attemptToSerialize(T request, @Nullable Object body) {
        try {
            if (body instanceof String) {
                return body;
            }
            if (body instanceof InputStream) {
                Long contentLength = this.tryGetContentLength(request);
                if (this.isApacheNonBufferingClient && contentLength != null && contentLength > 0L) {
                    if (body instanceof DuplicatableInputStream) {
                        return new ApacheDuplicatableInputStreamEntity((DuplicatableInputStream)body, contentLength);
                    }
                    return new ApacheInputStreamEntity((InputStream)body, contentLength);
                }
                return body;
            }
            if (body != null) {
                return RestClientFactory.getObjectMapper().writeValueAsString(body);
            }
            return "";
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to process JSON body", e);
        }
    }

    private <T extends BmcRequest> Long tryGetContentLength(T request) {
        if (request instanceof HasContentLength) {
            return ((HasContentLength)((Object)request)).getContentLength();
        }
        return null;
    }

    public ClientConfigurator getClientConfigurator() {
        return this.clientConfigurator;
    }

    static final class InvocationInformation {
        private final String requestId;
        private final MultivaluedMap<String, Object> headersSetInCallback;

        @ConstructorProperties(value={"requestId", "headersSetInCallback"})
        public InvocationInformation(String requestId, MultivaluedMap<String, Object> headersSetInCallback) {
            this.requestId = requestId;
            this.headersSetInCallback = headersSetInCallback;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public MultivaluedMap<String, Object> getHeadersSetInCallback() {
            return this.headersSetInCallback;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvocationInformation)) {
                return false;
            }
            InvocationInformation other = (InvocationInformation)o;
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            MultivaluedMap<String, Object> this$headersSetInCallback = this.getHeadersSetInCallback();
            MultivaluedMap<String, Object> other$headersSetInCallback = other.getHeadersSetInCallback();
            return !(this$headersSetInCallback == null ? other$headersSetInCallback != null : !this$headersSetInCallback.equals(other$headersSetInCallback));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            MultivaluedMap<String, Object> $headersSetInCallback = this.getHeadersSetInCallback();
            result = result * 59 + ($headersSetInCallback == null ? 43 : $headersSetInCallback.hashCode());
            return result;
        }

        public String toString() {
            return "RestClient.InvocationInformation(requestId=" + this.getRequestId() + ", headersSetInCallback=" + this.getHeadersSetInCallback() + ")";
        }
    }

    private static class Callback
    implements InvocationCallback<Response> {
        private static final Logger LOG = LoggerFactory.getLogger(Callback.class);
        private final WebTarget baseTarget;
        private final InvocationInformation info;
        private final Consumer<Response> onSuccess;
        private final Consumer<Throwable> onError;

        private Callback(@NonNull WebTarget baseTarget, @NonNull InvocationInformation info, @Nullable Consumer<Response> onSuccess, @Nullable Consumer<Throwable> onError) {
            if (baseTarget == null) {
                throw new NullPointerException("baseTarget is marked non-null but is null");
            }
            if (info == null) {
                throw new NullPointerException("info is marked non-null but is null");
            }
            this.baseTarget = baseTarget;
            this.info = info;
            this.onSuccess = onSuccess;
            this.onError = onError;
        }

        public void completed(Response response) {
            if (this.onSuccess == null) {
                LOG.debug("Request completed sucessfully but no handler configured");
                return;
            }
            try {
                this.onSuccess.accept(response);
            }
            catch (Exception e) {
                LOG.debug("Failure during success handling", (Throwable)e);
                this.failed(e);
            }
        }

        public void failed(Throwable throwable) {
            if (this.onError == null) {
                LOG.debug("Detected failure, but no handler configured");
                return;
            }
            this.onError.accept(this.handleException(throwable));
        }

        private Throwable handleException(Throwable throwable) {
            if (throwable instanceof ProcessingException) {
                return RestClient.convertToBmcException(this.baseTarget, (ProcessingException)throwable, this.info);
            }
            return throwable;
        }
    }

    static class NonSubmittingInvocationBuilder
    extends ForwardingInvocationBuilder {
        private final WrappedInvocationBuilder delegate;

        @Override
        public Invocation.Builder delegate() {
            return this.delegate;
        }

        @Override
        public Response get() {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T get(Class<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T get(GenericType<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Response put(Entity<?> entity) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T put(Entity<?> entity, Class<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T put(Entity<?> entity, GenericType<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Response post(Entity<?> entity) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T post(Entity<?> entity, Class<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T post(Entity<?> entity, GenericType<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Response delete() {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T delete(Class<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T delete(GenericType<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Response head() {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Response options() {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T options(Class<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T options(GenericType<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Response trace() {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T trace(Class<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T trace(GenericType<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Response method(String name) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T method(String name, Class<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T method(String name, GenericType<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Response method(String name, Entity<?> entity) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T method(String name, Entity<?> entity, Class<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Invocation build(String method) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Invocation build(String method, Entity<?> entity) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Invocation buildGet() {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Invocation buildDelete() {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Invocation buildPost(Entity<?> entity) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public Invocation buildPut(Entity<?> entity) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public AsyncInvoker async() {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public CompletionStageRxInvoker rx() {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @Override
        public <T extends RxInvoker> T rx(Class<T> aClass) {
            throw new UnsupportedOperationException("Cannot issue request directly");
        }

        @ConstructorProperties(value={"delegate"})
        public NonSubmittingInvocationBuilder(WrappedInvocationBuilder delegate) {
            this.delegate = delegate;
        }
    }
}

