/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field14S
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "14S";
    public static final String F_14S = "14S";
    public static final Integer SOURCE = 1;
    public static final Integer NUMBER = 2;
    public static final Integer TIME = 3;
    public static final Integer LOCATION = 4;

    public Field14S() {
        super(4);
    }

    public Field14S(String value) {
        super(value);
    }

    public Field14S(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"14S")) {
            throw new IllegalArgumentException("cannot create field 14S from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field14S newInstance(Field14S source) {
        Field14S cp = new Field14S();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("14S", value);
    }

    public static Tag emptyTag() {
        return new Tag("14S", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            String left;
            String right = null;
            if (value.indexOf(47) >= 0) {
                left = SwiftParseUtils.getTokenFirst(value, "/");
                right = SwiftParseUtils.getTokenSecondLast(value, "/");
            } else {
                left = value;
            }
            this.setComponent1(SwiftParseUtils.getAlphaPrefix(left));
            String second = this.getComponent1() == null ? left : StringUtils.substringAfter((String)left, (String)this.getComponent1());
            this.setComponent2(second);
            if (right != null) {
                this.setComponent3(SwiftParseUtils.getTokenFirst(right, "/"));
                this.setComponent4(SwiftParseUtils.getTokenSecondLast(right, "/"));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        if (this.getComponent3() != null || this.getComponent4() != null) {
            result.append("/");
            this.append(result, 3);
            result.append("/");
            this.append(result, 4);
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 14S");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            Calendar cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return this.getComponent(4);
    }

    @Override
    public String typesPattern() {
        return "SNHS";
    }

    @Override
    public String parserPattern() {
        return "SN[/<HHMM>/S]";
    }

    @Override
    public String validatorPattern() {
        return "3!a2!n[/<HHMM>/4!c]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 3) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Source");
        result.add("Number");
        result.add("Time");
        result.add("Location");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "source");
        result.put(2, "number");
        result.put(3, "time");
        result.put(4, "location");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("source", 1);
        this.labelMap.put("number", 2);
        this.labelMap.put("time", 3);
        this.labelMap.put("location", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getSource() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    public String getNumber() {
        return this.getComponent2();
    }

    public Long getNumberAsLong() {
        return this.getComponent2AsLong();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getTime() {
        return this.getComponent3();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent3AsCalendar();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getLocation() {
        return this.getComponent4();
    }

    public Field14S setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field14S setSource(String component1) {
        return this.setComponent1(component1);
    }

    public Field14S setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field14S setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field14S setNumber(String component2) {
        return this.setComponent2(component2);
    }

    public Field14S setNumber(Number component2) {
        return this.setComponent2(component2);
    }

    public Field14S setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field14S setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    public Field14S setTime(String component3) {
        return this.setComponent3(component3);
    }

    public Field14S setTime(Calendar component3) {
        return this.setComponent3(component3);
    }

    public Field14S setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field14S setLocation(String component4) {
        return this.setComponent4(component4);
    }

    @Override
    public String getName() {
        return "14S";
    }

    public static Field14S get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("14S");
        if (t == null) {
            return null;
        }
        return new Field14S(t);
    }

    public static Field14S get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field14S.get(msg.getBlock4());
    }

    public static List<Field14S> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field14S.getAll(msg.getBlock4());
    }

    public static List<Field14S> getAll(SwiftTagListBlock block) {
        ArrayList<Field14S> result = new ArrayList<Field14S>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("14S");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field14S(f));
            }
        }
        return result;
    }

    public static Field14S fromJson(String json) {
        Field14S field = new Field14S();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("source") != null) {
            field.setComponent1(jsonObject.get("source").getAsString());
        }
        if (jsonObject.get("number") != null) {
            field.setComponent2(jsonObject.get("number").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent3(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("location") != null) {
            field.setComponent4(jsonObject.get("location").getAsString());
        }
        return field;
    }

    public String getRateSource() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        return result.toString();
    }

    public Field14S setRateSource(String rateSource) {
        String source = SwiftParseUtils.getAlphaPrefix(rateSource);
        String number = source == null ? rateSource : StringUtils.substringAfter((String)rateSource, (String)source);
        this.setComponent1(StringUtils.trimToNull((String)source));
        this.setComponent2(StringUtils.trimToNull((String)number));
        return this;
    }

    public String getTimeAndLocation() {
        if (StringUtils.isBlank((CharSequence)this.getComponent3()) && StringUtils.isBlank((CharSequence)this.getComponent4())) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("/");
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        return result.toString();
    }

    public Field14S setTimeAndLocation(String timeAndLocation) {
        String time = null;
        String location = null;
        if (StringUtils.indexOf((CharSequence)timeAndLocation, (int)47) != -1) {
            timeAndLocation = SwiftParseUtils.removePrefix(timeAndLocation, "/");
            time = SwiftParseUtils.getTokenFirst(timeAndLocation, "/");
            location = SwiftParseUtils.getTokenSecond(timeAndLocation, "/");
        }
        this.setComponent3(StringUtils.trimToNull(time));
        this.setComponent4(StringUtils.trimToNull(location));
        return this;
    }
}

