/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field140;
import com.prowidesoftware.swift.model.field.Field144;
import com.prowidesoftware.swift.model.field.Field251;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT025
extends AbstractMT
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT025.class.getName());
    public static final String NAME = "025";

    public MT025(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT025(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT025 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT025(m);
    }

    public MT025() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT025(String sender, String receiver) {
        super(25, sender, receiver);
    }

    public MT025(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT025.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT025 object from FIN content with a Service Message. Check if the MT025 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT025 object from FIN content with message type " + param.getType());
        }
    }

    public static MT025 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT025(fin);
    }

    public MT025(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT025 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT025(stream);
    }

    public MT025(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT025 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT025(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT025 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT025 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT025 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT025 fromJson(String json) {
        return (MT025)AbstractMT.fromJson(json);
    }

    public Field251 getField251() {
        Tag t = this.tag("251");
        if (t != null) {
            return new Field251(t.getValue());
        }
        return null;
    }

    public Field140 getField140() {
        Tag t = this.tag("140");
        if (t != null) {
            return new Field140(t.getValue());
        }
        return null;
    }

    public Field144 getField144() {
        Tag t = this.tag("144");
        if (t != null) {
            return new Field144(t.getValue());
        }
        return null;
    }
}

