/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field12;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field77E;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT998
extends AbstractMT
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT998.class.getName());
    public static final String NAME = "998";

    public MT998(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT998(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT998 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT998(m);
    }

    public MT998() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT998(String sender, String receiver) {
        super(998, sender, receiver);
    }

    public MT998(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT998.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT998 object from FIN content with a Service Message. Check if the MT998 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT998 object from FIN content with message type " + param.getType());
        }
    }

    public static MT998 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT998(fin);
    }

    public MT998(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT998 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT998(stream);
    }

    public MT998(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT998 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT998(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT998 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT998 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT998 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT998 fromJson(String json) {
        return (MT998)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field12 getField12() {
        Tag t = this.tag("12");
        if (t != null) {
            return new Field12(t.getValue());
        }
        return null;
    }

    public Field77E getField77E() {
        Tag t = this.tag("77E");
        if (t != null) {
            return new Field77E(t.getValue());
        }
        return null;
    }
}

