/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToIntFunction;

@FileStatefulCheck
public class FinalClassCheck
extends AbstractCheck {
    public static final String MSG_KEY = "final.class";
    private static final String PACKAGE_SEPARATOR = ".";
    private Map<String, ClassDesc> innerClasses;
    private Map<DetailAST, String> anonInnerClassToOuterTypeDecl;
    private Deque<TypeDeclarationDescription> typeDeclarations;
    private String packageName;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{157, 14, 154, 15, 199, 8, 16, 136};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.typeDeclarations = new ArrayDeque<TypeDeclarationDescription>();
        this.innerClasses = new LinkedHashMap<String, ClassDesc>();
        this.anonInnerClassToOuterTypeDecl = new HashMap<DetailAST, String>();
        this.packageName = "";
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                this.packageName = CheckUtil.extractQualifiedName(ast.getFirstChild().getNextSibling());
                break;
            }
            case 15: 
            case 154: 
            case 157: 
            case 199: {
                TypeDeclarationDescription description = new TypeDeclarationDescription(this.extractQualifiedTypeName(ast), 0, ast);
                this.typeDeclarations.push(description);
                break;
            }
            case 14: {
                this.visitClass(ast);
                break;
            }
            case 8: {
                this.visitCtor(ast);
                break;
            }
            case 136: {
                if (ast.getFirstChild() == null || ast.getLastChild().getType() != 6) break;
                this.anonInnerClassToOuterTypeDecl.put(ast, this.typeDeclarations.peek().getQualifiedName());
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private void visitClass(DetailAST ast) {
        String qualifiedClassName = this.extractQualifiedTypeName(ast);
        ClassDesc currClass = new ClassDesc(qualifiedClassName, this.typeDeclarations.size(), ast);
        this.typeDeclarations.push(currClass);
        this.innerClasses.put(qualifiedClassName, currClass);
    }

    private void visitCtor(DetailAST ast) {
        DetailAST modifiers;
        if (!ScopeUtil.isInEnumBlock(ast) && !ScopeUtil.isInRecordBlock(ast) && (modifiers = ast.findFirstToken(5)).findFirstToken(61) == null) {
            ClassDesc desc = (ClassDesc)this.typeDeclarations.getFirst();
            desc.registerNonPrivateCtor();
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (TokenUtil.isTypeDeclaration(ast.getType())) {
            this.typeDeclarations.pop();
        }
        if (TokenUtil.isRootNode(ast.getParent())) {
            this.anonInnerClassToOuterTypeDecl.forEach(this::registerAnonymousInnerClassToSuperClass);
            this.innerClasses.forEach(this::registerExtendedClass);
            this.innerClasses.forEach((qualifiedClassName, classDesc) -> {
                if (FinalClassCheck.shouldBeDeclaredAsFinal(classDesc)) {
                    String className = CommonUtil.baseClassName(qualifiedClassName);
                    this.log(classDesc.getTypeDeclarationAst(), MSG_KEY, className);
                }
            });
        }
    }

    private static boolean shouldBeDeclaredAsFinal(ClassDesc classDesc) {
        boolean skipClass;
        boolean bl = skipClass = classDesc.isDeclaredAsFinal() || classDesc.isDeclaredAsAbstract() || classDesc.isSuperClassOfAnonymousInnerClass() || classDesc.isWithNestedSubclass();
        boolean shouldBeFinal = skipClass ? false : (classDesc.isHasDeclaredConstructor() ? classDesc.isDeclaredAsPrivate() : !classDesc.isWithNonPrivateCtor());
        return shouldBeFinal;
    }

    private void registerExtendedClass(String qualifiedClassName, ClassDesc currentClass) {
        String superClassName = FinalClassCheck.getSuperClassName(currentClass.getTypeDeclarationAst());
        if (superClassName != null) {
            ToIntFunction<ClassDesc> nestedClassCountProvider = classDesc -> CheckUtil.typeDeclarationNameMatchingCount(qualifiedClassName, classDesc.getQualifiedName());
            this.getNearestClassWithSameName(superClassName, nestedClassCountProvider).or(() -> Optional.ofNullable(this.innerClasses.get(superClassName))).ifPresent(rec$ -> ((ClassDesc)rec$).registerNestedSubclass());
        }
    }

    private void registerAnonymousInnerClassToSuperClass(DetailAST literalNewAst, String outerTypeDeclName) {
        String superClassName = CheckUtil.getShortNameOfAnonInnerClass(literalNewAst);
        ToIntFunction<ClassDesc> anonClassCountProvider = classDesc -> FinalClassCheck.getAnonSuperTypeMatchingCount(outerTypeDeclName, classDesc.getQualifiedName());
        this.getNearestClassWithSameName(superClassName, anonClassCountProvider).or(() -> Optional.ofNullable(this.innerClasses.get(superClassName))).ifPresent(rec$ -> ((ClassDesc)rec$).registerSuperClassOfAnonymousInnerClass());
    }

    private Optional<ClassDesc> getNearestClassWithSameName(String className, ToIntFunction<ClassDesc> countProvider) {
        String dotAndClassName = PACKAGE_SEPARATOR.concat(className);
        Comparator<ClassDesc> longestMatch = Comparator.comparingInt(countProvider);
        return this.innerClasses.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith(dotAndClassName)).map(Map.Entry::getValue).min(longestMatch.reversed().thenComparingInt(TypeDeclarationDescription::getDepth));
    }

    private String extractQualifiedTypeName(DetailAST typeDeclarationAst) {
        String className = typeDeclarationAst.findFirstToken(58).getText();
        String outerTypeDeclarationQualifiedName = null;
        if (!this.typeDeclarations.isEmpty()) {
            outerTypeDeclarationQualifiedName = this.typeDeclarations.peek().getQualifiedName();
        }
        return CheckUtil.getQualifiedTypeDeclarationName(this.packageName, outerTypeDeclarationQualifiedName, className);
    }

    private static String getSuperClassName(DetailAST classAst) {
        String superClassName = null;
        DetailAST classExtend = classAst.findFirstToken(18);
        if (classExtend != null) {
            superClassName = CheckUtil.extractQualifiedName(classExtend.getFirstChild());
        }
        return superClassName;
    }

    private static int getAnonSuperTypeMatchingCount(String patternTypeDeclaration, String typeDeclarationToBeMatched) {
        int typeDeclarationToBeMatchedLength = typeDeclarationToBeMatched.length();
        int minLength = Math.min(typeDeclarationToBeMatchedLength, patternTypeDeclaration.length());
        char packageSeparator = PACKAGE_SEPARATOR.charAt(0);
        boolean shouldCountBeUpdatedAtLastCharacter = typeDeclarationToBeMatchedLength > minLength && typeDeclarationToBeMatched.charAt(minLength) == packageSeparator;
        int result = 0;
        for (int idx = 0; idx < minLength && patternTypeDeclaration.charAt(idx) == typeDeclarationToBeMatched.charAt(idx); ++idx) {
            if ((idx != minLength - 1 || !shouldCountBeUpdatedAtLastCharacter) && patternTypeDeclaration.charAt(idx) != packageSeparator) continue;
            result = idx;
        }
        return result;
    }

    private static class TypeDeclarationDescription {
        private final String qualifiedName;
        private final int depth;
        private final DetailAST typeDeclarationAst;

        private TypeDeclarationDescription(String qualifiedName, int depth, DetailAST typeDeclarationAst) {
            this.qualifiedName = qualifiedName;
            this.depth = depth;
            this.typeDeclarationAst = typeDeclarationAst;
        }

        protected String getQualifiedName() {
            return this.qualifiedName;
        }

        protected int getDepth() {
            return this.depth;
        }

        protected DetailAST getTypeDeclarationAst() {
            return this.typeDeclarationAst;
        }
    }

    private static final class ClassDesc
    extends TypeDeclarationDescription {
        private final boolean declaredAsFinal;
        private final boolean declaredAsAbstract;
        private final boolean declaredAsPrivate;
        private final boolean hasDeclaredConstructor;
        private boolean withNonPrivateCtor;
        private boolean withNestedSubclass;
        private boolean superClassOfAnonymousInnerClass;

        private ClassDesc(String qualifiedName, int depth, DetailAST classAst) {
            super(qualifiedName, depth, classAst);
            DetailAST modifiers = classAst.findFirstToken(5);
            this.declaredAsFinal = modifiers.findFirstToken(39) != null;
            this.declaredAsAbstract = modifiers.findFirstToken(40) != null;
            this.declaredAsPrivate = modifiers.findFirstToken(61) != null;
            this.hasDeclaredConstructor = classAst.getLastChild().findFirstToken(8) == null;
        }

        private void registerNonPrivateCtor() {
            this.withNonPrivateCtor = true;
        }

        private void registerNestedSubclass() {
            this.withNestedSubclass = true;
        }

        private void registerSuperClassOfAnonymousInnerClass() {
            this.superClassOfAnonymousInnerClass = true;
        }

        private boolean isWithNonPrivateCtor() {
            return this.withNonPrivateCtor;
        }

        private boolean isWithNestedSubclass() {
            return this.withNestedSubclass;
        }

        private boolean isDeclaredAsFinal() {
            return this.declaredAsFinal;
        }

        private boolean isDeclaredAsAbstract() {
            return this.declaredAsAbstract;
        }

        private boolean isSuperClassOfAnonymousInnerClass() {
            return this.superClassOfAnonymousInnerClass;
        }

        private boolean isHasDeclaredConstructor() {
            return this.hasDeclaredConstructor;
        }

        private boolean isDeclaredAsPrivate() {
            return this.declaredAsPrivate;
        }
    }
}

