/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractAccessControlNameCheck;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;

public class ConstantNameCheck
extends AbstractAccessControlNameCheck {
    public ConstantNameCheck() {
        super("^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{10};
    }

    @Override
    protected final boolean mustCheckName(DetailAST ast) {
        DetailAST nameAST;
        boolean isFinal;
        boolean returnValue = false;
        DetailAST modifiersAST = ast.findFirstToken(5);
        boolean isStatic = modifiersAST.findFirstToken(64) != null;
        boolean bl = isFinal = modifiersAST.findFirstToken(39) != null;
        if ((isStatic && isFinal && this.shouldCheckInScope(modifiersAST) || ScopeUtils.isInAnnotationBlock(ast) || ScopeUtils.isInInterfaceOrAnnotationBlock(ast) && !ScopeUtils.isInCodeBlock(ast)) && !"serialVersionUID".equals((nameAST = ast.findFirstToken(58)).getText()) && !"serialPersistentFields".equals(nameAST.getText())) {
            returnValue = true;
        }
        return returnValue;
    }
}

