/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@StatelessCheck
public final class IllegalCatchCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.catch";
    private final Set<String> illegalClassNames = Arrays.stream(new String[]{"Exception", "Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Throwable"}).collect(Collectors.toSet());

    public void setIllegalClassNames(String ... classNames) {
        this.illegalClassNames.clear();
        this.illegalClassNames.addAll(CheckUtil.parseClassNames(classNames));
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{96};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST detailAST) {
        DetailAST parameterDef = detailAST.findFirstToken(21);
        DetailAST excTypeParent = parameterDef.findFirstToken(13);
        List<DetailAST> excTypes = IllegalCatchCheck.getAllExceptionTypes(excTypeParent);
        for (DetailAST excType : excTypes) {
            FullIdent ident = FullIdent.createFullIdent(excType);
            if (!this.illegalClassNames.contains(ident.getText())) continue;
            this.log(detailAST, MSG_KEY, ident.getText());
        }
    }

    private static List<DetailAST> getAllExceptionTypes(DetailAST parentToken) {
        DetailAST currentNode = parentToken.getFirstChild();
        LinkedList<DetailAST> exceptionTypes = new LinkedList<DetailAST>();
        if (currentNode.getType() == 112) {
            exceptionTypes.addAll(IllegalCatchCheck.getAllExceptionTypes(currentNode));
            currentNode = currentNode.getNextSibling();
            if (currentNode != null) {
                exceptionTypes.add(currentNode);
            }
        } else {
            exceptionTypes.add(currentNode);
            for (currentNode = currentNode.getNextSibling(); currentNode != null; currentNode = currentNode.getNextSibling()) {
                exceptionTypes.add(currentNode);
            }
        }
        return exceptionTypes;
    }
}

