/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.recovery;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.rabbitmq.client.impl.recovery.DefaultRetryHandler;
import com.rabbitmq.client.impl.recovery.RecordedBinding;
import com.rabbitmq.client.impl.recovery.RecordedConsumer;
import com.rabbitmq.client.impl.recovery.RecordedEntity;
import com.rabbitmq.client.impl.recovery.RecordedQueue;
import com.rabbitmq.client.impl.recovery.RecordedQueueBinding;
import com.rabbitmq.client.impl.recovery.RetryContext;
import com.rabbitmq.client.impl.recovery.TopologyRecoveryRetryHandlerBuilder;
import com.rabbitmq.utility.Utility;

public abstract class TopologyRecoveryRetryLogic {
    public static final DefaultRetryHandler.RetryCondition<RecordedEntity> CHANNEL_CLOSED_NOT_FOUND = new DefaultRetryHandler.RetryCondition<RecordedEntity>(){

        @Override
        public boolean test(RecordedEntity entity, Exception e) {
            ShutdownSignalException cause;
            if (e.getCause() instanceof ShutdownSignalException && (cause = (ShutdownSignalException)e.getCause()).getReason() instanceof AMQP.Channel.Close) {
                return ((AMQP.Channel.Close)cause.getReason()).getReplyCode() == 404;
            }
            return false;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CHANNEL = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext context) throws Exception {
            if (!context.entity().getChannel().isOpen()) {
                context.connection().recoverChannel(context.entity().getChannel());
            }
            return null;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_BINDING_QUEUE = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext context) {
            if (context.entity() instanceof RecordedQueueBinding) {
                RecordedBinding binding = context.binding();
                AutorecoveringConnection connection = context.connection();
                RecordedQueue recordedQueue = connection.getRecordedQueues().get(binding.getDestination());
                if (recordedQueue != null) {
                    connection.recoverQueue(recordedQueue.getName(), recordedQueue, false);
                }
            }
            return null;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_BINDING = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext context) throws Exception {
            context.binding().recover();
            return null;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CONSUMER_QUEUE = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext context) {
            if (context.entity() instanceof RecordedConsumer) {
                RecordedConsumer consumer = context.consumer();
                AutorecoveringConnection connection = context.connection();
                RecordedQueue recordedQueue = connection.getRecordedQueues().get(consumer.getQueue());
                if (recordedQueue != null) {
                    connection.recoverQueue(recordedQueue.getName(), recordedQueue, false);
                }
            }
            return null;
        }
    };
    public static final DefaultRetryHandler.RetryOperation<String> RECOVER_CONSUMER = new DefaultRetryHandler.RetryOperation<String>(){

        @Override
        public String call(RetryContext context) throws Exception {
            return context.consumer().recover();
        }
    };
    public static final DefaultRetryHandler.RetryOperation<Void> RECOVER_CONSUMER_QUEUE_BINDINGS = new DefaultRetryHandler.RetryOperation<Void>(){

        @Override
        public Void call(RetryContext context) throws Exception {
            if (context.entity() instanceof RecordedConsumer) {
                String queue = context.consumer().getQueue();
                for (RecordedBinding recordedBinding : Utility.copy(context.connection().getRecordedBindings())) {
                    if (!(recordedBinding instanceof RecordedQueueBinding) || !queue.equals(recordedBinding.getDestination())) continue;
                    recordedBinding.recover();
                }
            }
            return null;
        }
    };
    public static final TopologyRecoveryRetryHandlerBuilder RETRY_ON_QUEUE_NOT_FOUND_RETRY_HANDLER = TopologyRecoveryRetryHandlerBuilder.builder().bindingRecoveryRetryCondition(CHANNEL_CLOSED_NOT_FOUND).consumerRecoveryRetryCondition(CHANNEL_CLOSED_NOT_FOUND).bindingRecoveryRetryOperation(RECOVER_CHANNEL.andThen(RECOVER_BINDING_QUEUE).andThen(RECOVER_BINDING)).consumerRecoveryRetryOperation(RECOVER_CHANNEL.andThen(RECOVER_CONSUMER_QUEUE.andThen(RECOVER_CONSUMER).andThen(RECOVER_CONSUMER_QUEUE_BINDINGS)));
}

