/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.jasperreports.auth;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.remote.ServicesUtils;
import com.rsmart.rfabric.auth.tokenauth.AuthToken;
import com.rsmart.rfabric.auth.tokenauth.springsecurity.AuthTokenAuthentication;
import com.rsmart.rfabric.jasperreports.auth.AuthTokenAuthenticationUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.ProviderManager;

public class AuthTokenAuthenticationFilter
implements Filter,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(AuthTokenAuthenticationFilter.class);
    public static final String AUTH_TOKEN_HEADER = "x-authn-token";
    public static final String AUTH_TOKEN_PARAM = "authntoken";
    public static final String[] FIELDS = new String[]{"KCID", "ISPI", "client"};
    private static ApplicationContext applicationContext = null;
    private static ServicesUtils servicesUtils = null;
    private AuthenticationManager authenticationManager;

    public void destroy() {
    }

    public final AuthToken getToken(HttpServletRequest request) {
        String token;
        log.debug((Object)"getToken(final HttpServletRequest request)");
        if (request == null) {
            throw new IllegalArgumentException("request == null");
        }
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            Enumeration names = request.getHeaderNames();
            String delim = "";
            while (names.hasMoreElements()) {
                sb.append(delim);
                sb.append((String)names.nextElement());
                delim = ", ";
            }
            log.trace((Object)("headers: " + sb.toString()));
            sb = new StringBuilder();
            names = request.getParameterNames();
            delim = "";
            while (names.hasMoreElements()) {
                sb.append(delim);
                sb.append((String)names.nextElement());
                delim = ", ";
            }
            log.trace((Object)("params: " + sb.toString()));
        }
        if ((token = request.getHeader(AUTH_TOKEN_HEADER)) == null) {
            token = request.getParameter(AUTH_TOKEN_PARAM);
            if (token != null) {
                log.debug((Object)"token passed as request parameter authntoken");
            }
        } else {
            log.debug((Object)"token passed as request header x-authn-token");
        }
        if (token == null) {
            log.debug((Object)"no authentication token found");
            return null;
        }
        log.debug((Object)("retrieved authentication token: " + token));
        return new AuthToken(token, FIELDS);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        Authentication authResult;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        AuthToken credential = this.getToken(request);
        if (credential == null) {
            chain.doFilter(servletRequest, servletResponse);
            return;
        }
        AuthToken existing = AuthTokenAuthenticationUtil.getCurrentAuthToken();
        if (existing != null && existing.equals((Object)credential)) {
            log.debug((Object)"already validated authentication token presented again, skipping authentication");
            chain.doFilter(servletRequest, servletResponse);
            return;
        }
        log.debug((Object)"request has an AuthToken - attempting to authenticate");
        AuthTokenAuthentication authentication = new AuthTokenAuthentication(credential);
        try {
            authResult = this.authenticationManager.authenticate((Authentication)authentication);
        }
        catch (AuthenticationException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token " + credential + " failed to authenticate: " + e.toString()));
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("Token " + credential + " failed to authenticate: " + e.toString() + " " + (Object)((Object)e)), e.getRootCause());
            }
            SecurityContextHolder.getContext().setAuthentication(null);
            response.setStatus(401);
            OperationResult or = servicesUtils.createOperationResult(1, "Failed authentication for token " + credential);
            PrintWriter pw = response.getWriter();
            pw.print("Unauthorized");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User " + authentication.getName() + " authenticated: " + authResult));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        if (log.isDebugEnabled() && authenticationManager instanceof ProviderManager) {
            StringBuffer buff = new StringBuffer();
            buff.append("AuthenticationProviders:\n");
            ProviderManager pm = (ProviderManager)authenticationManager;
            List providers = pm.getProviders();
            for (AuthenticationProvider provider : providers) {
                buff.append("\t").append(provider.getClass().toString()).append("\n");
            }
            log.debug((Object)buff.toString());
        }
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        applicationContext = ac;
        servicesUtils = (ServicesUtils)ac.getBean(ServicesUtils.class);
    }

    public void init(FilterConfig fc) throws ServletException {
    }
}

