/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.jasperreports.auth;

import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.rsmart.rfabric.auth.tokenauth.springsecurity.AuthTokenAuthentication;
import com.rsmart.rfabric.auth.tokenauth.springsecurity.UserDetailProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;

public class JasperUserDetailProvider
implements UserDetailProvider {
    private static final Log LOG = LogFactory.getLog(JasperUserDetailProvider.class);
    protected transient UserDetailsService userDetailsService;

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void populateUserDetails(String userId, AuthTokenAuthentication authentication) {
        LOG.debug((Object)("returning details for " + userId));
        UserDetails user = this.userDetailsService.loadUserByUsername(userId);
        if (user instanceof MetadataUserDetails) {
            ((MetadataUserDetails)user).setOriginalAuthentication((Authentication)authentication);
        } else {
            LOG.error((Object)"JasperServer's UserDetailsService is not returning a MetadataUserDetails object as expected - no field from the AuthToken will be available during the user's session!!!");
        }
        authentication.setName(userId);
        authentication.setAuthorities(user.getAuthorities());
        authentication.setPrincipal((Object)user);
    }

    public boolean userExists(String userId) {
        UserDetails user = this.userDetailsService.loadUserByUsername(userId);
        return user != null;
    }
}

