/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.jasperreports.datasource.db;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.JdbcReportDataSourceImpl;
import com.rsmart.rfabric.auth.multitenant.MultiTenantDataSourceInfoService;
import com.rsmart.rfabric.auth.multitenant.MultiTenantInfo;
import com.rsmart.rfabric.jasperreports.datasource.ClientDataSourceService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbClientDataSourceServiceImpl
implements ClientDataSourceService {
    private static final Log LOG = LogFactory.getLog(DbClientDataSourceServiceImpl.class);
    private MultiTenantDataSourceInfoService multiTenantDataSourceInfoService;

    @Override
    public JdbcReportDataSource getDataSourceServiceForClient(String client) {
        return this.getDataSourceForTenant(this.multiTenantDataSourceInfoService.getTenantInfoByClientId(client));
    }

    private JdbcReportDataSource getDataSourceForTenant(MultiTenantInfo tenantInfo) {
        if (tenantInfo != null) {
            JdbcReportDataSourceImpl ds = new JdbcReportDataSourceImpl();
            ds.setConnectionUrl(tenantInfo.getUrl());
            ds.setDriverClass(tenantInfo.getDriver());
            ds.setUsername(tenantInfo.getUsername());
            ds.setPassword(tenantInfo.getPassword());
            return ds;
        }
        return null;
    }

    @Override
    public JdbcReportDataSource getDataSourceServiceForUser(String userId) {
        return this.getDataSourceForTenant(this.multiTenantDataSourceInfoService.getTenantInfoByUserId(userId));
    }

    public MultiTenantDataSourceInfoService getMultiTenantDataSourceInfoService() {
        return this.multiTenantDataSourceInfoService;
    }

    public void setMultiTenantDataSourceInfoService(MultiTenantDataSourceInfoService multiTenantDataSourceInfoService) {
        this.multiTenantDataSourceInfoService = multiTenantDataSourceInfoService;
    }
}

