/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormattedLogger {
    private static final String getMessage(String pattern, Object ... objs) {
        StringWriter retval = new StringWriter();
        PrintWriter writer = new PrintWriter(retval);
        writer.printf(pattern, objs);
        return retval.toString();
    }

    private static final Log getLog() {
        try {
            return LogFactory.getLog(Class.forName(new Throwable().getStackTrace()[3].getClassName()));
        }
        catch (Exception e) {
            return LogFactory.getLog(FormattedLogger.class);
        }
    }

    public static final void trace(String pattern, Object ... objs) {
        Log log = FormattedLogger.getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)FormattedLogger.getMessage(pattern, objs));
        }
    }

    public static final void debug(String pattern, Object ... objs) {
        Log log = FormattedLogger.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)FormattedLogger.getMessage(pattern, objs));
        }
    }

    public static final void info(String pattern, Object ... objs) {
        Log log = FormattedLogger.getLog();
        if (log.isInfoEnabled()) {
            log.info((Object)FormattedLogger.getMessage(pattern, objs));
        }
    }

    public static final void warn(String pattern, Object ... objs) {
        Log log = FormattedLogger.getLog();
        if (log.isWarnEnabled()) {
            log.warn((Object)FormattedLogger.getMessage(pattern, objs));
        }
    }

    public static final void error(String pattern, Object ... objs) {
        Log log = FormattedLogger.getLog();
        if (log.isErrorEnabled()) {
            FormattedLogger.getLog().error((Object)FormattedLogger.getMessage(pattern, objs));
        }
    }

    public static final void fatal(String pattern, Object ... objs) {
        Log log = FormattedLogger.getLog();
        if (log.isFatalEnabled()) {
            log.fatal((Object)FormattedLogger.getMessage(pattern, objs));
        }
    }
}

