/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.jasperreports.datasource.db;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.JdbcReportDataSourceImpl;
import com.rsmart.rfabric.jasperreports.datasource.ClientDataSourceService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbClientDataSourceServiceImpl
implements ClientDataSourceService {
    private static final Log LOG = LogFactory.getLog(DbClientDataSourceServiceImpl.class);
    private static final String VALIDATE_QUERY = "SELECT count(client) FROM db_info";
    private static final String TRACE_VALIDATE_QUERY = "SELECT client FROM db_info";
    private static final String CLIENT_QUERY = "SELECT url, driver, username, password FROM db_info WHERE client=?";
    protected DataSource dataSource;

    public DataSource getDataSource() {
        LOG.trace((Object)"getDataSource()");
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("setDataSource(DataSource " + dataSource + ")"));
        }
        this.dataSource = dataSource;
        this.validateDbSchema();
    }

    private void validateDbSchema() {
        LOG.trace((Object)"validateDbSchema()");
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            PreparedStatement stmt = null;
            if (LOG.isTraceEnabled()) {
                stmt = conn.prepareStatement(TRACE_VALIDATE_QUERY);
                StringBuilder sb = new StringBuilder();
                sb.append("DB contains datasource info for these clients: ");
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    sb.append(rs.getString("client"));
                }
                LOG.trace((Object)sb.toString());
            } else {
                stmt = conn.prepareStatement(VALIDATE_QUERY);
                int count = 0;
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                LOG.debug((Object)("client datasources configured: " + count));
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"error validating connection info database", (Throwable)e);
            throw new IllegalStateException("DB validation failed", e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Could not close the Connection cleanly; giving up.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public JdbcReportDataSource getDataSourceServiceForClient(String tenant) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("getDataSourceServiceForClient(String " + tenant + ")"));
        }
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            PreparedStatement stmt = conn.prepareStatement(CLIENT_QUERY);
            stmt.setString(1, tenant);
            ResultSet rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                JdbcReportDataSourceImpl ds = new JdbcReportDataSourceImpl();
                ds.setConnectionUrl(rs.getString("url"));
                ds.setDriverClass(rs.getString("driver"));
                ds.setUsername(rs.getString("username"));
                ds.setPassword(rs.getString("password"));
                LOG.debug((Object)rs.getString("url"));
                LOG.debug((Object)rs.getString("driver"));
                LOG.debug((Object)rs.getString("username"));
                LOG.debug((Object)rs.getString("password"));
                JdbcReportDataSourceImpl jdbcReportDataSourceImpl = ds;
                return jdbcReportDataSourceImpl;
            }
            try {
                LOG.error((Object)("No datasource defined for tenant: " + tenant));
                throw new IllegalStateException("No datasource defined for tenant!");
            }
            catch (SQLException e) {
                LOG.error((Object)"DB failure prevented client datasource lookup", (Throwable)e);
                throw new IllegalStateException("DB failure prevented client datasource lookup", e);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Could not close the Connection cleanly; giving up.", (Throwable)e);
                }
            }
        }
    }
}

