/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.kuali.coeus.hr.rest.model;

import com.rsmart.kuali.coeus.hr.rest.model.HRImport;
import com.rsmart.kuali.coeus.hr.rest.model.HRImportRecordCollection;
import com.rsmart.kuali.coeus.hr.rest.model.StAXHRImportRecordCollection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.input.BOMInputStream;

public class StAXHRImport
implements HRImport {
    protected XMLStreamReader xsr;
    protected BOMInputStream fis;
    protected BigDecimal schemaVersion;
    protected String statusEmailRecipient;
    protected Date reportDate;
    protected int recordCount;
    protected StAXHRImportRecordCollection records;

    public StAXHRImport(String importFile) {
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            this.fis = new BOMInputStream((InputStream)new FileInputStream(importFile));
            StreamSource xml = new StreamSource((InputStream)this.fis);
            this.xsr = xif.createXMLStreamReader(xml);
            this.readAttributes();
            this.records = new StAXHRImportRecordCollection(new File(importFile), this.recordCount);
            this.xsr.close();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("error reading XML import: " + e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("could not find import file: " + importFile, e);
        }
        finally {
            if (this.fis != null) {
                try {
                    this.fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void readAttributes() {
        try {
            this.xsr.nextTag();
            if (this.xsr.getLocalName().equals("hrmanifest")) {
                int attribCount = this.xsr.getAttributeCount();
                for (int i = 0; i < attribCount; ++i) {
                    QName attribName = this.xsr.getAttributeName(i);
                    String attribLocalPart = attribName.getLocalPart();
                    String attribValue = this.xsr.getAttributeValue(i);
                    if ("schemaVersion".equals(attribLocalPart)) {
                        this.schemaVersion = DatatypeConverter.parseDecimal((String)attribValue);
                        continue;
                    }
                    if ("statusEmailRecipient".equals(attribLocalPart)) {
                        this.statusEmailRecipient = attribValue;
                        continue;
                    }
                    if ("reportDate".equals(attribLocalPart)) {
                        Calendar cal = DatatypeConverter.parseDateTime((String)attribValue);
                        this.reportDate = cal.getTime();
                        continue;
                    }
                    if (!"recordCount".equals(attribLocalPart)) continue;
                    this.recordCount = DatatypeConverter.parseInt((String)attribValue);
                }
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Failed to parse XML: " + e.getMessage(), e);
        }
    }

    @Override
    public BigDecimal getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public String getStatusEmailRecipient() {
        return this.statusEmailRecipient;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public HRImportRecordCollection getRecords() {
        return this.records;
    }

    @Override
    public Date getReportDate() {
        return this.reportDate;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.fis != null) {
            this.fis.close();
        }
    }
}

