/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.kuali.coeus.hr.service.adapter;

import java.util.Comparator;
import org.kuali.rice.core.api.mo.common.Defaultable;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.krad.service.LegacyDataAdapter;

public abstract class PersistableBoMergeAdapter<T, X>
implements Comparator<T> {
    protected boolean boIsInactivatable = false;
    protected boolean boIsDefaultable = false;

    public PersistableBoMergeAdapter() {
        Class<T> clazz = this.getBusinessObjectClass();
        this.boIsInactivatable = Inactivatable.class.isAssignableFrom(clazz);
        this.boIsDefaultable = Defaultable.class.isAssignableFrom(clazz);
    }

    public final int nullSafeCompare(String val0, String val1) {
        String comp0 = val0 == null ? "" : val0;
        String comp1 = val1 == null ? "" : val1;
        return comp0.compareTo(comp1);
    }

    public final int nullSafeCompareIgnoreCase(String val0, String val1) {
        String comp0 = val0 == null ? "" : val0;
        String comp1 = val1 == null ? "" : val1;
        return comp0.compareToIgnoreCase(comp1);
    }

    @Override
    public final int compare(T bo0, T bo1) {
        int comp = 0;
        if (this.isBoDefaultable()) {
            int bo0Dft = ((Defaultable)bo0).isDefaultValue() ? 1 : 0;
            int bo1Dft = ((Defaultable)bo1).isDefaultValue() ? 1 : 0;
            comp = bo1Dft - bo0Dft;
            if (comp != 0) {
                return comp;
            }
        }
        if (this.isBoInactivatable()) {
            int bo0Active = ((Inactivatable)bo0).isActive() ? 1 : 0;
            int bo1Active = ((Inactivatable)bo1).isActive() ? 1 : 0;
            comp = bo1Active - bo0Active;
            if (comp != 0) {
                return comp;
            }
        }
        return this.compareBOProperties(bo0, bo1);
    }

    public boolean isBoInactivatable() {
        return this.boIsInactivatable;
    }

    public boolean isBoDefaultable() {
        return this.boIsDefaultable;
    }

    public T save(int index, LegacyDataAdapter legacyDataAdapter, T bo) {
        return (T)legacyDataAdapter.save(bo);
    }

    public void delete(LegacyDataAdapter legacyDataAdapter, T bo) {
        legacyDataAdapter.delete(bo);
    }

    public abstract int compareBOProperties(T var1, T var2);

    public abstract T newBO(String var1);

    public abstract T setFields(T var1, X var2);

    public T setFields(int index, T bo, X source) {
        return this.setFields(bo, source);
    }

    public abstract Class<T> getBusinessObjectClass();

    public abstract Class<X> getIncomingClass();
}

