/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.kuali.coeus.hr.rest.model;

import com.rsmart.kuali.coeus.hr.rest.model.HRImportRecord;
import com.rsmart.kuali.coeus.hr.rest.model.HRImportRecordCollection;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StAXHRImportRecordCollection
implements HRImportRecordCollection {
    private static final Logger LOG = LoggerFactory.getLogger(StAXHRImportRecordCollection.class);
    protected File file = null;
    protected int count = 0;

    public StAXHRImportRecordCollection(File file, int count) {
        this.file = file;
        this.count = count;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Iterator<HRImportRecord> iterator() {
        return new RecordIterator();
    }

    class RecordIterator
    implements Iterator<HRImportRecord> {
        boolean next = false;
        FileInputStream fis = null;
        XMLStreamReader xsr = null;
        JAXBContext jc = null;
        Unmarshaller unmarshaller = null;

        public RecordIterator() {
            try {
                XMLInputFactory xif = XMLInputFactory.newFactory();
                FileInputStream fis = new FileInputStream(StAXHRImportRecordCollection.this.file);
                StreamSource xml = new StreamSource(fis);
                this.xsr = xif.createXMLStreamReader(xml);
                this.jc = JAXBContext.newInstance((Class[])new Class[]{HRImportRecord.class});
                this.unmarshaller = this.jc.createUnmarshaller();
                this.xsr.nextTag();
                while (!this.xsr.getLocalName().equals("record")) {
                    LOG.debug(this.xsr.getLocalName());
                    this.xsr.nextTag();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading XML", e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.xsr != null && this.xsr.isStartElement() && "record".equals(this.xsr.getLocalName())) {
                return true;
            }
            this.closeAll();
            return false;
        }

        @Override
        public HRImportRecord next() {
            if (this.xsr == null) {
                throw new NoSuchElementException("iterator has no next element");
            }
            try {
                JAXBElement recordElement = this.unmarshaller.unmarshal(this.xsr, HRImportRecord.class);
                this.xsr.nextTag();
                HRImportRecord hRImportRecord = (HRImportRecord)recordElement.getValue();
                return hRImportRecord;
            }
            catch (Exception e) {
                try {
                    while (this.xsr.hasNext() && !this.xsr.isStartElement() && !"record".equals(this.xsr.getLocalName())) {
                        this.xsr.nextTag();
                    }
                }
                catch (Exception e1) {
                    LOG.error("attempt to recover from malformed record failed, parse ending", (Throwable)e1);
                }
                throw new RuntimeException("Error reading XML: " + e.getMessage(), e);
            }
            finally {
                if (!this.hasNext()) {
                    this.closeAll();
                }
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Operation not permitted");
        }

        protected void closeAll() {
            if (this.xsr != null) {
                try {
                    this.xsr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.xsr = null;
            if (this.fis != null) {
                try {
                    this.fis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fis = null;
        }
    }
}

