package com.rsmart.kuali.coeus.hr.rest.model;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Part of the HRImport object graph that is created when the HR import XML
 * file is parsed.
 * 
 * See {@link com.rsmart.kuali.coeus.hr.rest.model.DOMHRImport HRImport} for more details.
 * @author duffy
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "employment")
public class Employment extends ModelObject {

  @XmlAttribute
  @NotNull
  protected float baseSalaryAmount = 0.0f;
  @XmlAttribute
  @NotNull
  protected String employeeId = null;
  @XmlAttribute
  @NotNull
  protected String employeeStatus = null;
  @XmlAttribute
  @NotNull
  protected String employeeType = null;
  @XmlElement(name = "employment", type = Employment.class)
  @Valid
  protected Employment employment = null;
  @XmlAttribute
  @NotNull
  protected String primaryDepartment = null;
  @XmlAttribute
  protected boolean primaryEmployment = true;
  protected String entityAffiliationId = null;
  
  public float getBaseSalaryAmount() {
    return baseSalaryAmount;
  }
  public String getEmployeeId() {
    return employeeId;
  }
  public String getEmployeeStatus() {
    return employeeStatus;
  }
  public String getEmployeeType() {
    return employeeType;
  }
  public String getPrimaryDepartment() {
    return primaryDepartment;
  }
  public boolean isPrimaryEmployment() {
    return primaryEmployment;
  }
  public String getEntityAffiliationId() { return entityAffiliationId; }
  public void setBaseSalaryAmount(float baseSalaryAmount) {
    this.baseSalaryAmount = baseSalaryAmount;
  }
  public void setEmployeeId(String employeeId) {
    this.employeeId=trimToNull(employeeId);
  }
  public void setEmployeeStatus(String employeeStatus) {
    this.employeeStatus=trimToNull(employeeStatus);
  }
  public void setEmployeeType(String employeeType) {
    this.employeeType=trimToNull(employeeType);
  }
  public void setPrimaryDepartment(String primaryDepartment) {
    this.primaryDepartment=trimToNull(primaryDepartment);
  }
  public void setPrimaryEmployment(boolean primaryEmployment) {
    this.primaryEmployment = primaryEmployment;
  }
  public void setEntityAffiliationId(String entityAffiliationId) { this.entityAffiliationId = entityAffiliationId; }

}
