package com.rsmart.kuali.coeus.hr.service.adapter.impl;

import java.util.Date;

import org.kuali.coeus.common.budget.framework.personnel.AppointmentType;
import org.kuali.coeus.common.framework.person.attr.PersonAppointment;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

import com.rsmart.kuali.coeus.hr.rest.model.Appointment;
import com.rsmart.kuali.coeus.hr.service.adapter.PersistableBoMergeAdapter;
import org.kuali.rice.krad.service.LegacyDataAdapter;

public class PersonAppointmentBoAdapter extends PersistableBoMergeAdapter<PersonAppointment, Appointment> {

  protected UnitService unitService = null;
  
  public void setUnitService (final UnitService unitService) {
    this.unitService = unitService;
  }
  
  @Override
  public int compareBOProperties(PersonAppointment bo0, PersonAppointment bo1) {
    int comp = 0;
    // both are null so return equal
    if (bo0 == null && bo1 == null) {
      return comp;
    }
    
    //  private Integer appointmentId;
    final Integer appointmentId0 = bo0.getAppointmentId();
    final Integer appointmentId1 = bo1.getAppointmentId();
    if (appointmentId0 != null) {
      comp = appointmentId0.compareTo(appointmentId1);
    }
    if (comp != 0) {
      return comp;
    }

    comp = nullSafeCompare(bo0.getTypeCode(), bo1.getTypeCode());
    if (comp != 0) {
      return comp;
    }

    // compare AppointmentTypeCode
    // https://github.com/rSmart/issues/issues/287
    String atc0 = null;
    String atc1 = null;
    if (bo0.getAppointmentType() != null) {
      atc0 = bo0.getAppointmentType().getAppointmentTypeCode();
    }
    if (bo1.getAppointmentType() != null) {
      atc1 = bo1.getAppointmentType().getAppointmentTypeCode();
    }
    comp = nullSafeCompare(atc0, atc1);
    if (comp != 0) {
      return comp;
    }

    final Date endDate0 = bo0.getEndDate();
    final Date endDate1 = bo1.getEndDate();
    
    if (endDate0 != null) {
      comp = endDate0.compareTo(endDate1);
    } else {
      if (endDate1 != null) {
        return 1;
      }
      comp = 0;
    }
    if (comp != 0) {
      return comp;
    }
    
    // private String personId;
    comp = nullSafeCompare(bo0.getPersonId(), bo1.getPersonId());
    if (comp != 0) {
      return comp;
    }

    comp = nullSafeCompare(bo0.getJobCode(), bo1.getJobCode());
    if (comp != 0) {
      return comp;
    }
    comp = nullSafeCompare(bo0.getJobTitle(), bo1.getJobTitle());
    if (comp != 0) {
      return comp;
    }
    comp = nullSafeCompare(bo0.getPreferedJobTitle(), bo1.getPreferedJobTitle());
    if (comp != 0) {
      return comp;
    }
    
    final ScaleTwoDecimal sal0 = ScaleTwoDecimal.returnZeroIfNull(bo0.getSalary());
    final ScaleTwoDecimal sal1 = ScaleTwoDecimal.returnZeroIfNull(bo1.getSalary());

    comp = Float.compare(sal0.floatValue(),sal1.floatValue());
    if (comp != 0) {
      return comp;
    }

    final Date startDate0 = bo0.getStartDate();
    final Date startDate1 = bo1.getStartDate();
    
    if (startDate0 != null) {
      comp = startDate0.compareTo(startDate1);
    } else {
      if (startDate1 != null) {
        return 1;
      }
      comp = 0;
    }
    if (comp != 0) {
      return comp;
    }
    
    comp = nullSafeCompare(bo0.getUnitNumber(), bo1.getUnitNumber());
    
    return comp;
  }

  @Override
  public PersonAppointment newBO(String entityId) {
    final PersonAppointment appt = new PersonAppointment();
    
    appt.setPersonId(entityId);

    return appt;
  }

  @Override
  public PersonAppointment setFields(PersonAppointment bo, Appointment source) {
    // lookup AppointmentType object
    // https://github.com/rSmart/issues/issues/287
    final AppointmentType apptType = ((LegacyDataAdapter) KcServiceLocator.getService(
        "legacyDataAdapter")).findBySinglePrimaryKey(AppointmentType.class, source.getAppointmentType());
    if (apptType == null) {
      throw new IllegalStateException("Could not find AppointmentType for type code: "
          + source.getAppointmentType());
    }

    bo.setAppointmentType(apptType);
    bo.setTypeCode(source.getAppointmentType());
    bo.setJobCode(source.getJobCode());
    bo.setJobTitle(source.getJobTitle());
    bo.setPreferedJobTitle(source.getPreferedJobTitle());
    bo.setSalary(new ScaleTwoDecimal(source.getSalary()));
    final Date startDate = source.getStartDate();
    if (startDate != null) {
      bo.setStartDate(new java.sql.Date(startDate.getTime()));
    }
    final Date endDate = source.getEndDate();
    if (endDate != null) {
      bo.setEndDate(new java.sql.Date(endDate.getTime()));
    }
    
    if (unitService == null) {
      throw new IllegalStateException (PersonAppointmentBoAdapter.class.getSimpleName() + " does not have a UnitService implementation");
    }
    final String unitNumber = source.getUnitNumber();
    Unit unit = unitService.getUnit(unitNumber);
    bo.setUnit(unit);
    if (unit == null) {
      throw new IllegalArgumentException ("Unit number " + unitNumber + " does not exist");
    }
    bo.setUnitNumber(unit.getUnitNumber());
    
    return bo;
  }

  @Override
  public Class<PersonAppointment> getBusinessObjectClass() {
    return PersonAppointment.class;
  }

  @Override
  public Class<Appointment> getIncomingClass() {
    return Appointment.class;
  }

}
