/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.kuali.coeus.hr.rest.authn;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.util.GlobalVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KCBasicAuthFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(KCBasicAuthFilter.class);
    private static final String IMPORT_AUTHN_USER = "hrimport.authn.username";
    private static final String IMPORT_AUTHN_PASS = "hrimport.authn.password";
    private static final String IMPORT_AUTHN_RUN_AS = "hrimport.authn.runas";
    private static final String CORE_AUTH_ENABLED = "auth.core.enabled";
    private static final String PERMISSION_NAMESPACE = "KR-IDM";
    private static final String PERMISSION_NAME = "Modify Entity";
    private static final String AUTH_HEADER = "Authorization";
    protected LegacyDataAdapter legacyDataAdapter = null;
    protected IdentityService identityService = null;
    protected PermissionService permissionService = null;
    protected HashSet<String> authorizedUsers = null;
    protected String username = null;
    protected String password = null;
    protected String runAs = null;

    public LegacyDataAdapter getLegacyDataAdapter() {
        if (this.legacyDataAdapter == null) {
            this.legacyDataAdapter = (LegacyDataAdapter)KcServiceLocator.getService((String)"legacyDataAdapter");
        }
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    public IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    protected String getUsername() {
        return ConfigContext.getCurrentContextConfig().getProperty(IMPORT_AUTHN_USER);
    }

    protected String getPassword() {
        return ConfigContext.getCurrentContextConfig().getProperty(IMPORT_AUTHN_PASS);
    }

    protected String getRunAsUser() {
        return ConfigContext.getCurrentContextConfig().getProperty(IMPORT_AUTHN_RUN_AS);
    }

    protected Boolean isCoreAuthEnabled() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty(CORE_AUTH_ENABLED);
    }

    protected Boolean doesUserHavePermission(String principalId) {
        return this.getPermissionService().hasPermission(principalId, PERMISSION_NAMESPACE, PERMISSION_NAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected UserSession authenticateKCUser(String principalName, String password) throws GeneralSecurityException {
        Principal principal = null;
        String username = this.getUsername();
        String fixedPassword = this.getPassword();
        String runas = this.getRunAsUser();
        if (username != null && fixedPassword != null) {
            if (runas == null) {
                LOG.error("no runas user set! Fixed credentials cannot be used without it. Please configure hrimport.authn.runas to indicate the valid KIM user to use for import");
            } else {
                if (!username.equals(principalName) || !fixedPassword.equals(password)) return null;
                LOG.debug("user authenticated against fixed username and password");
                principal = this.getIdentityService().getPrincipalByPrincipalName(runas);
                if (principal == null) {
                    LOG.error("could not retrieve runas user '" + runas + "' -- user cannot authenitcate!");
                    return null;
                }
            }
        } else {
            LOG.debug("no fixed username and password configured: authenticating against KIM\n configure hrimport.authn.username, hrimport.authn.password, and hrimport.authn.runas to authentication against fixed credentials");
        }
        if (principal == null) {
            if (this.authorizedUsers != null && !this.authorizedUsers.contains(principalName)) {
                LOG.debug(principalName + " is not in the authorized users list: aborting authentication");
                return null;
            }
            String convertedPw = null;
            convertedPw = CoreApiServiceLocator.getEncryptionService().hash((Object)password);
            principal = this.getIdentityService().getPrincipalByPrincipalNameAndPassword(principalName, convertedPw);
        }
        if (principal != null) {
            UserSession userSession = new UserSession(principal.getPrincipalName());
            GlobalVariables.setUserSession((UserSession)userSession);
            return userSession;
        }
        LOG.debug("unable to retrieve user " + principalName + " with the supplied password");
        return null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String plaintext;
        String[] parts;
        HttpServletRequest httpReq = (HttpServletRequest)request;
        String authHeader = httpReq.getHeader(AUTH_HEADER);
        if (this.isCoreAuthEnabled().booleanValue()) {
            if (!this.doesUserHavePermission(GlobalVariables.getUserSession().getPrincipalId()).booleanValue()) {
                LOG.error("user does not have approriate permission for access the hr-import server");
                HttpServletResponse httpResp = (HttpServletResponse)response;
                httpResp.sendError(401);
                return;
            }
            filterChain.doFilter(request, response);
            return;
        }
        UserSession session = null;
        if (authHeader != null && (parts = authHeader.split("\\s+")).length == 2 && "basic".equalsIgnoreCase(parts[0]) && (plaintext = new String(DatatypeConverter.parseBase64Binary((String)parts[1]))) != null && plaintext.length() > 0) {
            String[] credentials = plaintext.split(":");
            try {
                session = this.authenticateKCUser(credentials[0], credentials[1]);
            }
            catch (GeneralSecurityException e) {
                LOG.error("security exception encountered during authentication", (Throwable)e);
                HttpServletResponse httpResp = (HttpServletResponse)response;
                httpResp.sendError(500);
                return;
            }
        }
        if (session == null) {
            LOG.debug("user is not authenticated");
            HttpServletResponse httpResp = (HttpServletResponse)response;
            httpResp.setHeader("WWW-Authentication", "Basic realm=\"" + httpReq.getRequestURI() + "\"");
            httpResp.sendError(401);
            return;
        }
        LOG.debug("authenticated user: '" + session.getPrincipalName() + "'");
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        String[] users;
        String hrUsers = config.getInitParameter("hrUsers");
        if (hrUsers != null && !hrUsers.isEmpty() && (users = hrUsers.split(",")).length > 0) {
            StringBuffer sb = new StringBuffer("HR import authorized users resricted to: ");
            String delim = "";
            this.authorizedUsers = new HashSet(users.length);
            for (String user : users) {
                sb.append(delim).append(user);
                delim = ",";
                this.authorizedUsers.add(user);
            }
            LOG.debug(sb.toString());
        }
    }

    public void destroy() {
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = (PermissionService)KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

