/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.auth.tokenauth;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthToken {
    public static final String TOKEN_SEPARATOR = ";";
    private String token = null;
    private String hash = null;
    private Date timestamp = null;
    private String nonce = null;
    private Map<String, String> credentials = null;
    private List<String> credentialFields = null;

    public AuthToken(String token, List<String> credentialFields) {
        this.credentialFields = credentialFields;
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("token is empty");
        }
        this.token = token;
        this.credentials = new HashMap<String, String>(credentialFields.size());
        String[] parts = token.split(TOKEN_SEPARATOR);
        if (parts == null || parts.length < 3 + credentialFields.size()) {
            throw new IllegalArgumentException("malformed token - it does not contain enough fields");
        }
        this.hash = parts[0];
        this.timestamp = new Date(Long.parseLong(parts[1]));
        this.nonce = parts[2];
        for (int i = 0; i < credentialFields.size(); ++i) {
            this.credentials.put(credentialFields.get(i), parts[3 + i]);
        }
    }

    public String getHash() {
        return this.hash;
    }

    public String getCredentialField(String fieldName) {
        if (!this.credentials.containsKey(fieldName)) {
            throw new IllegalArgumentException(fieldName + " is not defined for this AuthToken");
        }
        return this.credentials.get(fieldName);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getHashableFields() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timestamp.getTime()).append(TOKEN_SEPARATOR).append(this.nonce);
        for (String fieldName : this.credentialFields) {
            sb.append(TOKEN_SEPARATOR).append(this.getCredentialField(fieldName));
        }
        return sb.toString();
    }

    public String toString() {
        return this.token;
    }

    public boolean equals(Object that) {
        return that != null && that instanceof AuthToken && this.token != null && this.token.equals(((AuthToken)that).token);
    }
}

