/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.auth.tokenauth;

import com.rsmart.rfabric.auth.tokenauth.Signature;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Date;

public class AuthTokenGenerator {
    protected Signature signature = new Signature();
    protected String secret = null;

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getSecret() {
        return this.secret;
    }

    public String generateToken(String[] credentials) {
        StringBuilder sb = new StringBuilder();
        SecureRandom rand = new SecureRandom();
        int nonce = rand.nextInt();
        int numFields = 0;
        if (credentials != null) {
            numFields = credentials.length;
        }
        sb.append(new Date().getTime()).append(";").append(nonce);
        for (int i = 0; i < numFields; ++i) {
            sb.append(";").append(credentials[i]);
        }
        String toSign = sb.toString();
        try {
            String hmac = this.signature.calculateRFC2104HMACWithEncoding(toSign, this.getSecret(), true);
            return hmac + ";" + toSign;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid secret key", e);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage:\n\tjava " + AuthTokenGenerator.class.getName() + " <shared secret> [<credential 1> <credential 2> ...]");
            System.exit(1);
        }
        String[] credentials = new String[args.length - 1];
        System.arraycopy(args, 1, credentials, 0, args.length - 1);
        AuthTokenGenerator generator = new AuthTokenGenerator();
        generator.setSecret(args[0]);
        try {
            String token = generator.generateToken(credentials);
            System.out.println(token);
        }
        catch (RuntimeException re) {
            System.err.println("Failed to generate token");
            re.printStackTrace();
            System.exit(1);
        }
    }
}

