/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.auth.tokenauth;

import com.rsmart.rfabric.auth.tokenauth.AuthTokenGenerator;
import javax.servlet.http.HttpServletRequest;

public class AuthTokenURLGenerator {
    protected AuthTokenGenerator tokenGenerator = null;

    public AuthTokenGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    public void setTokenGenerator(AuthTokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public String generateRelativeURL(HttpServletRequest request, String path, String query, String[] credentials) {
        String token = this.getTokenGenerator().generateToken(credentials);
        String contextPath = request.getContextPath();
        String requestURL = request.getRequestURL().toString();
        int endPos = requestURL.indexOf(contextPath);
        String relativeRoot = requestURL.substring(0, endPos);
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(relativeRoot).append('/').append(path).append('?');
        if (query != null && query.length() > 0) {
            urlSb.append(query).append('&');
        }
        urlSb.append("authntoken=").append(token);
        return urlSb.toString();
    }

    public String generateAbsoluteURL(String path, String query, String[] credentials) {
        String token = this.getTokenGenerator().generateToken(credentials);
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(path).append('?');
        if (query != null && query.length() > 0) {
            urlSb.append(query).append('&');
        }
        urlSb.append("authntoken=").append(token);
        return urlSb.toString();
    }
}

