/*
 * Decompiled with CFR 0.152.
 */
package com.rsmart.rfabric.auth.tokenauth;

import com.rsmart.rfabric.auth.tokenauth.AuthToken;
import com.rsmart.rfabric.auth.tokenauth.Signature;
import java.security.InvalidKeyException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthTokenValidator {
    private static final Log LOG = LogFactory.getLog(AuthTokenValidator.class);
    private static final long DFT_TIMEOUT = 60000L;
    protected transient Signature signature = new Signature();
    protected transient String secret = null;
    protected transient long timeout = 60000L;

    public AuthTokenValidator() {
    }

    public AuthTokenValidator(String secret, long timeout) {
        this.setSecret(secret);
        this.setTimeout(timeout);
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected boolean hasTimedOut(AuthToken token) {
        long tokenTime;
        long now = new Date().getTime();
        return now - (tokenTime = token.getTimestamp().getTime()) > this.timeout;
    }

    public boolean isValid(AuthToken authToken) {
        String hmac;
        if (this.hasTimedOut(authToken)) {
            LOG.warn((Object)("Token has timed out: " + authToken.toString()));
            return false;
        }
        String message = authToken.getHashableFields();
        LOG.trace((Object)("hashable fields: " + message));
        try {
            hmac = this.signature.calculateRFC2104HMACWithEncoding(message, this.secret, true);
        }
        catch (InvalidKeyException ike) {
            LOG.error((Object)("Failed to validate token: " + authToken), (Throwable)ike);
            throw new IllegalStateException("Invalid key used for hashing", ike);
        }
        return hmac.equals(authToken.getHash());
    }
}

