/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.ColorUtils;
import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Expression;

class CompressCssFormatter
extends CssFormatter {
    private boolean wasSemicolon;

    CompressCssFormatter() {
        this.getFormat().setMinimumIntegerDigits(0);
    }

    @Override
    CssFormatter space() {
        return this;
    }

    @Override
    CssFormatter newline() {
        return this;
    }

    @Override
    void insets() {
    }

    @Override
    CssFormatter comment(String msg) {
        if (msg.startsWith("/*!")) {
            this.checkSemicolon();
            this.getOutput().append(msg);
        }
        return this;
    }

    @Override
    CssFormatter appendColor(double color, String hint) {
        int blue;
        int green;
        int red;
        if (!this.inlineMode() && (red = ColorUtils.red(color)) % 17 == 0 && (green = ColorUtils.green(color)) % 17 == 0 && (blue = ColorUtils.blue(color)) % 17 == 0) {
            super.append('#').append(Character.forDigit(red / 17, 16)).append(Character.forDigit(green / 17, 16)).append(Character.forDigit(blue / 17, 16));
            return this;
        }
        return super.appendColor(color, null);
    }

    @Override
    CssFormatter appendValue(double value, String unit) {
        if (value == 0.0 && !this.inlineMode()) {
            switch (unit) {
                case "deg": 
                case "s": {
                    break;
                }
                default: {
                    super.append('0');
                    return this;
                }
            }
        }
        return super.appendValue(value, unit);
    }

    @Override
    void semicolon() {
        this.wasSemicolon = true;
    }

    private void checkSemicolon() {
        if (this.wasSemicolon) {
            this.wasSemicolon = false;
            super.semicolon();
        }
    }

    @Override
    CssFormatter startBlock(String[] selectors) {
        this.checkSemicolon();
        CssFormatter formatter = super.startBlock(selectors);
        if (formatter != this && formatter.getOutput().length() > 0) {
            formatter.semicolon();
        }
        return formatter;
    }

    @Override
    void appendProperty(String name, Expression value) {
        this.checkSemicolon();
        super.appendProperty(name, value);
    }

    @Override
    CssFormatter endBlock() {
        this.wasSemicolon = false;
        return super.endBlock();
    }
}

