/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.CssOutput;
import com.inet.lib.less.CssPlainOutput;
import com.inet.lib.less.CssRuleOutput;
import com.inet.lib.less.LessExtendMap;
import java.util.ArrayList;

class CssMediaOutput
extends CssOutput {
    private String[] selectors;
    private ArrayList<CssOutput> results = new ArrayList();
    private boolean isReference;
    private LessExtendMap lessExtends;

    CssMediaOutput(String[] selectors, StringBuilder output, boolean isReference, LessExtendMap lessExtends) {
        this.selectors = selectors;
        this.results.add(new CssPlainOutput(output));
        this.isReference = isReference;
        this.lessExtends = lessExtends;
    }

    @Override
    void appendTo(StringBuilder target, LessExtendMap lessExtends, CssFormatter formatter) {
        if (this.hasContent(lessExtends)) {
            formatter.startBlockImpl(this.selectors);
            for (CssOutput cssOutput : this.results) {
                cssOutput.appendTo(target, this.lessExtends, formatter);
            }
            formatter.endBlockImpl();
        }
    }

    @Override
    boolean hasContent(LessExtendMap lessExtends) {
        for (CssOutput cssOutput : this.results) {
            if (!cssOutput.hasContent(this.lessExtends)) continue;
            return true;
        }
        return false;
    }

    @Override
    String[] getSelectors() {
        return this.selectors;
    }

    void startBlock(String[] selectors, StringBuilder output) {
        this.results.add(new CssRuleOutput(selectors, output, this.isReference));
    }

    @Override
    StringBuilder getOutput() {
        CssOutput cssOutput = this.results.get(this.results.size() - 1);
        if (cssOutput instanceof CssRuleOutput) {
            cssOutput = new CssPlainOutput(new StringBuilder());
            this.results.add(cssOutput);
        }
        return cssOutput.getOutput();
    }
}

