/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.LessException;
import com.inet.lib.less.LessObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Scanner;

class LessLookAheadReader
extends LessObject
implements Closeable {
    private final Reader reader;
    private final StringBuilder cache = new StringBuilder();
    private StringReader cache2;
    private final boolean isReference;
    private final boolean isMultiple;
    private int cachePos;

    LessLookAheadReader(Reader reader, String fileName, boolean isReference, boolean isMultiple) {
        super(fileName);
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
        this.isReference = isReference;
        this.isMultiple = isMultiple;
        this.line = 1;
        this.column = 0;
    }

    private int readCharBlockMarker() throws IOException {
        if (this.cache2 != null) {
            int ch = this.cache2.read();
            if (ch != -1) {
                return ch;
            }
            this.cache2 = null;
        }
        return this.reader.read();
    }

    int nextBlockMarker() throws LessException {
        if (this.cachePos < this.cache.length()) {
            String str = this.cache.substring(this.cachePos);
            if (this.cache2 != null) {
                try (Scanner scanner = new Scanner(this.cache2).useDelimiter("\\A");){
                    if (scanner.hasNext()) {
                        str = scanner.next() + str;
                    }
                }
            }
            this.cache2 = new StringReader(str);
        }
        this.cachePos = 0;
        this.cache.setLength(0);
        int parenthesis = 0;
        boolean isSlash = false;
        try {
            while (true) {
                int ch;
                if ((ch = this.readCharBlockMarker()) < 0) {
                    for (int i = 0; i < this.cache.length(); ++i) {
                        if (Character.isWhitespace(this.cache.charAt(i))) continue;
                        return 59;
                    }
                    return -1;
                }
                this.cache.append((char)ch);
                block5 : switch (ch) {
                    case 47: {
                        if (!isSlash || parenthesis > 0 && this.cache.indexOf("url") > 0) break;
                        this.cache.setLength(this.cache.length() - 2);
                        this.skipLine();
                        ch = 0;
                        break;
                    }
                    case 42: {
                        if (!isSlash) break;
                        boolean isAsterix = false;
                        while (true) {
                            if ((ch = this.readCharBlockMarker()) < 0) {
                                throw this.createException("Unrecognized input: '" + this.cache.toString().trim() + "'");
                            }
                            this.cache.append((char)ch);
                            if (ch == 47 && isAsterix) {
                                ch = 0;
                                break block5;
                            }
                            isAsterix = ch == 42;
                        }
                    }
                    case 123: {
                        boolean isBlock = true;
                        if (this.cache.length() > 1 && this.cache.charAt(this.cache.length() - 2) == '@') {
                            isBlock = false;
                        } else {
                            for (int i = this.cache.length() - 2; i > 0; --i) {
                                char c = this.cache.charAt(i);
                                if (Character.isWhitespace(c)) continue;
                                isBlock = c != ':';
                                break;
                            }
                        }
                        if (!isBlock) {
                            int braces = 1;
                            do {
                                ch = this.readCharBlockMarker();
                                switch (ch) {
                                    case -1: {
                                        throw this.createException("Unrecognized input: '" + this.cache.toString().trim() + "'");
                                    }
                                    case 125: {
                                        --braces;
                                        break;
                                    }
                                    case 123: {
                                        ++braces;
                                    }
                                }
                                this.cache.append((char)ch);
                            } while (braces > 0);
                            break;
                        }
                    }
                    case 59: 
                    case 125: {
                        if (parenthesis != 0) break;
                        return ch;
                    }
                    case 40: {
                        ++parenthesis;
                        break;
                    }
                    case 41: {
                        if (--parenthesis >= 0) break;
                        throw this.createException("Unrecognized input: '" + this.cache.toString().trim() + "'");
                    }
                    case 34: 
                    case 39: 
                    case 96: {
                        isSlash = false;
                        while (true) {
                            int ch2;
                            if ((ch2 = this.readCharBlockMarker()) < 0) {
                                return 59;
                            }
                            this.cache.append((char)ch2);
                            if (ch == ch2 && !isSlash) break block5;
                            isSlash = ch2 == 92;
                        }
                    }
                    case 92: {
                        this.cache.append((char)this.readCharBlockMarker());
                        break;
                    }
                }
                isSlash = ch == 47;
            }
        }
        catch (IOException ex) {
            throw new LessException(ex);
        }
    }

    String getLookAhead() {
        return this.cache.toString();
    }

    boolean nextIsMixinParam(boolean isBlock) {
        boolean isFirst = true;
        block10: for (int i = this.cachePos; i < this.cache.length(); ++i) {
            char ch = this.cache.charAt(i);
            switch (ch) {
                case ')': {
                    return true;
                }
                case '@': {
                    return this.cache.charAt(i + 1) != '{';
                }
                case '~': {
                    return true;
                }
                case '\"': {
                    return !isBlock;
                }
                case '.': {
                    if (!isFirst) continue block10;
                    if (Character.isDigit(this.cache.charAt(i + 1))) {
                        return true;
                    }
                    return i + 2 < this.cache.length() && this.cache.charAt(i + 1) == '.' && this.cache.charAt(i + 2) == '.';
                }
                case ':': 
                case '[': {
                    return false;
                }
                case '{': {
                    return true;
                }
                case ' ': {
                    continue block10;
                }
                default: {
                    isFirst = false;
                }
            }
        }
        return false;
    }

    char read() throws LessException {
        try {
            if (this.cachePos < this.cache.length()) {
                return this.incLineColumn(this.cache.charAt(this.cachePos++));
            }
            int ch = this.readCharBlockMarker();
            if (ch == -1) {
                throw this.createException("Unexpected end of Less data");
            }
            return this.incLineColumn(ch);
        }
        catch (IOException ex) {
            throw new LessException(ex);
        }
    }

    void back(char ch) {
        --this.cachePos;
        this.cache.setCharAt(this.cachePos, ch);
        --this.column;
    }

    void skipLine() {
        int ch;
        do {
            try {
                ch = this.reader.read();
            }
            catch (IOException ex) {
                throw new LessException(ex);
            }
            this.incLineColumn(ch);
        } while (ch != 10 && ch != -1);
    }

    private char incLineColumn(int ch) {
        if (ch == 10) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        return (char)ch;
    }

    int getLine() {
        return this.line;
    }

    int getColumn() {
        return this.column;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    boolean isReference() {
        return this.isReference;
    }

    boolean isMultiple() {
        return this.isMultiple;
    }
}

