/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Expression;
import com.inet.lib.less.Formattable;
import com.inet.lib.less.FormattableContainer;
import com.inet.lib.less.HashMultimap;
import com.inet.lib.less.LessException;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.Mixin;
import com.inet.lib.less.MixinMatch;
import com.inet.lib.less.Operation;
import com.inet.lib.less.SelectorUtils;
import com.inet.lib.less.ValueExpression;
import com.inet.lib.less.VariableExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class Rule
extends LessObject
implements Formattable,
FormattableContainer {
    private static final HashMap<String, Expression> NO_MATCH = new HashMap();
    private FormattableContainer parent;
    private String[] selectors;
    private final List<Expression> params;
    private VariableExpression varArg;
    private Expression guard;
    private List<Formattable> properties = new ArrayList<Formattable>();
    private List<Rule> subrules = new ArrayList<Rule>();
    private HashMap<String, Expression> variables = new HashMap();
    private HashMultimap<String, Rule> mixins;

    Rule(LessObject obj, FormattableContainer parent, String selectors, @Nullable Operation params, Expression guard) {
        super(obj);
        this.parent = parent;
        this.mixins = new HashMultimap<String, Rule>(parent.getMixins());
        this.selectors = SelectorUtils.split(selectors);
        if (params == null) {
            this.params = null;
        } else {
            String name;
            Expression lastEx;
            this.params = params.getOperands();
            int count = this.params.size();
            if (count > 0 && ((lastEx = this.params.get(count - 1)).getClass() == VariableExpression.class || lastEx.getClass() == ValueExpression.class) && (name = lastEx.toString()).endsWith("...")) {
                this.varArg = new VariableExpression(lastEx, name.substring(0, name.length() - 3));
                this.params.remove(count - 1);
            }
        }
        this.guard = guard;
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public void prepare(CssFormatter formatter) {
        for (Formattable prop : this.properties) {
            prop.prepare(formatter);
        }
    }

    @Override
    public void add(Formattable formattable) {
        this.properties.add(formattable);
        if (formattable instanceof Rule) {
            this.subrules.add((Rule)formattable);
        }
    }

    @Override
    public void appendTo(CssFormatter formatter) {
        if (this.isValidCSS(formatter)) {
            try {
                this.appendTo(null, formatter);
            }
            catch (LessException ex) {
                ex.addPosition(this.filename, this.line, this.column);
                throw ex;
            }
        }
    }

    void appendTo(@Nullable String[] mainSelector, CssFormatter formatter) {
        try {
            String[] sel = this.selectors;
            for (int s = 0; s < sel.length; ++s) {
                String selector = sel[s];
                String str = SelectorUtils.replacePlaceHolder(formatter, selector, this);
                if (selector == str) continue;
                if (sel == this.selectors) {
                    sel = (String[])sel.clone();
                }
                sel[s] = str;
            }
            if (mainSelector == null) {
                for (int i = 0; i < sel.length; ++i) {
                    sel[i] = SelectorUtils.fastReplace(sel[i], "&", "");
                }
            } else {
                if (sel[0].charAt(0) == '@') {
                    this.bubbling(sel, mainSelector, formatter);
                    return;
                }
                sel = SelectorUtils.merge(mainSelector, sel);
            }
            formatter.addMixin(this, null, this.variables);
            if (sel[0].startsWith("@")) {
                this.ruleset(sel, formatter);
            } else {
                if (this.properties.size() > 0) {
                    int size0 = formatter.getOutputSize();
                    CssFormatter block = formatter.startBlock(sel);
                    int size1 = block.getOutputSize();
                    this.appendPropertiesTo(block);
                    int size2 = block.getOutputSize();
                    block.endBlock();
                    if (block == formatter && size1 == size2) {
                        formatter.setOutputSize(size0);
                    }
                }
                for (Formattable prop : this.properties) {
                    if (!(prop instanceof Mixin)) continue;
                    ((Mixin)prop).appendSubRules(sel, formatter);
                }
                for (Rule rule : this.subrules) {
                    if (!rule.isValidCSS(formatter) || rule.isInlineRule(formatter)) continue;
                    rule.appendTo(this.params != null ? mainSelector : sel, formatter);
                }
            }
            formatter.removeMixin();
        }
        catch (LessException ex) {
            ex.addPosition(this.filename, this.line, this.column);
            throw ex;
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }

    private void bubbling(String[] mediaSelector, String[] blockSelector, CssFormatter formatter) {
        if (this.properties.size() > 0) {
            String media = mediaSelector[0];
            if (media.startsWith("@media") || media.startsWith("@supports") || media.startsWith("@document")) {
                int size0 = formatter.getOutputSize();
                CssFormatter block = formatter.startBlock(mediaSelector);
                if (block != formatter) {
                    size0 = block.getOutputSize();
                }
                CssFormatter block2 = block.startBlock(blockSelector);
                int size1 = block2.getOutputSize();
                this.appendPropertiesTo(block2);
                int size2 = block2.getOutputSize();
                block2.endBlock();
                int size3 = block.getOutputSize();
                for (Formattable prop : this.properties) {
                    if (!(prop instanceof Mixin)) continue;
                    ((Mixin)prop).appendSubRules(blockSelector, block);
                }
                int size4 = block.getOutputSize();
                block.endBlock();
                if (size1 == size2 && size3 == size4) {
                    block.setOutputSize(size0);
                }
            } else {
                CssFormatter block = formatter.startBlock(mediaSelector);
                this.appendPropertiesTo(block);
                for (Rule rule : this.subrules) {
                    rule.appendTo(null, block);
                }
                block.endBlock();
                return;
            }
        }
        for (Rule rule : this.subrules) {
            String[] ruleSelector = rule.getSelectors();
            String name = ruleSelector[0];
            if ((name = SelectorUtils.replacePlaceHolder(formatter, name, this)).startsWith("@media")) {
                rule.bubbling(new String[]{mediaSelector[0] + " and " + name.substring(6).trim()}, blockSelector, formatter);
                continue;
            }
            rule.bubbling(mediaSelector, SelectorUtils.merge(blockSelector, ruleSelector), formatter);
        }
    }

    private void ruleset(String[] sel, CssFormatter formatter) {
        formatter = formatter.startBlock(sel);
        this.appendPropertiesTo(formatter);
        for (Formattable prop : this.properties) {
            if (!(prop instanceof Mixin)) continue;
            ((Mixin)prop).appendSubRules(null, formatter);
        }
        for (Rule rule : this.subrules) {
            rule.appendTo(formatter);
        }
        formatter.endBlock();
    }

    void appendMixinsTo(String[] parentSelector, CssFormatter formatter) {
        for (Formattable prop : this.properties) {
            switch (prop.getType()) {
                case 2: {
                    ((Mixin)prop).appendSubRules(parentSelector, formatter);
                    break;
                }
                case 4: 
                case 5: {
                    prop.appendTo(formatter);
                }
            }
        }
    }

    void appendPropertiesTo(CssFormatter formatter) {
        if (this.properties.isEmpty()) {
            return;
        }
        formatter.addVariables(this.variables);
        block3: for (Formattable prop : this.properties) {
            switch (prop.getType()) {
                case 1: {
                    Rule rule = (Rule)prop;
                    if (!rule.isValidCSS(formatter) || !rule.isInlineRule(formatter)) continue block3;
                    rule.appendPropertiesTo(formatter);
                    continue block3;
                }
            }
            prop.appendTo(formatter);
        }
        formatter.removeVariables(this.variables);
    }

    private Map<String, Expression> getMixinParams(CssFormatter formatter, List<Expression> paramValues) {
        if (this.params == null && paramValues == null || paramValues == null && this.params.size() == 0 || this.params == null && paramValues.size() == 0) {
            return null;
        }
        if (this.params == null && paramValues != null) {
            return NO_MATCH;
        }
        if (paramValues == null) {
            paramValues = Collections.emptyList();
        }
        if (this.params.size() < paramValues.size() && this.varArg == null) {
            return NO_MATCH;
        }
        try {
            ArrayList<Expression> keyValue;
            int i;
            LinkedHashMap<String, Expression> vars = new LinkedHashMap<String, Expression>();
            int paramsCount = this.params.size();
            for (i = 0; i < paramsCount; ++i) {
                Expression param = this.params.get(i);
                Class<?> paramType = param.getClass();
                if (paramType != Operation.class || ((Operation)param).getOperator() != ':' || ((Operation)param).getOperands().size() != 2) continue;
                keyValue = ((Operation)param).getOperands();
                String name = keyValue.get(0).toString();
                vars.put(name, ValueExpression.eval(formatter, keyValue.get(1)));
            }
            paramsCount = Math.min(paramsCount, paramValues.size());
            for (i = 0; i < paramsCount; ++i) {
                Expression value = paramValues.get(i);
                Class<?> valueType = value.getClass();
                if (valueType == Operation.class && ((Operation)value).getOperator() == ':' && ((Operation)value).getOperands().size() == 2) {
                    keyValue = ((Operation)value).getOperands();
                    vars.put(keyValue.get(0).toString(), ValueExpression.eval(formatter, keyValue.get(1)));
                    continue;
                }
                Expression param = this.params.get(i);
                Class<?> paramType = param.getClass();
                if (paramType == VariableExpression.class) {
                    vars.put(param.toString(), ValueExpression.eval(formatter, value));
                    continue;
                }
                if (paramType == Operation.class && ((Operation)param).getOperator() == ':' && ((Operation)param).getOperands().size() == 2) {
                    ArrayList<Expression> keyValue2 = ((Operation)param).getOperands();
                    vars.put(keyValue2.get(0).toString(), ValueExpression.eval(formatter, value));
                    continue;
                }
                if (paramType == ValueExpression.class) {
                    Operation op = new Operation(param, param, '=');
                    op.addOperand(value);
                    if (!op.booleanValue(formatter)) {
                        return NO_MATCH;
                    }
                    vars.put(" " + i, value);
                    continue;
                }
                throw this.createException("Wrong formatted parameters: " + this.params);
            }
            if (this.varArg != null) {
                Operation value = new Operation(this.varArg);
                for (int i2 = this.params.size(); i2 < paramValues.size(); ++i2) {
                    value.addOperand(ValueExpression.eval(formatter, paramValues.get(i2)));
                }
                if (vars.size() == this.params.size()) {
                    vars.put(this.varArg.toString(), value);
                    return vars;
                }
                return NO_MATCH;
            }
            if (vars.size() == this.params.size()) {
                return vars;
            }
            return NO_MATCH;
        }
        catch (LessException ex) {
            ex.addPosition(this.filename, this.line, this.column);
            throw ex;
        }
    }

    String[] getSelectors() {
        return this.selectors;
    }

    @Override
    public HashMap<String, Expression> getVariables() {
        return this.variables;
    }

    @Override
    public HashMultimap<String, Rule> getMixins() {
        return this.mixins;
    }

    List<Rule> getSubrules() {
        return this.subrules;
    }

    List<Rule> getMixin(String name) {
        ArrayList<Rule> rules = null;
        block0: for (Rule rule : this.subrules) {
            for (String sel : rule.selectors) {
                if (!name.equals(sel)) continue;
                if (rules == null) {
                    rules = new ArrayList<Rule>();
                }
                rules.add(rule);
                continue block0;
            }
        }
        return rules;
    }

    public String toString() {
        CssFormatter formatter = new CssFormatter();
        try {
            this.appendTo(null, formatter);
        }
        catch (Exception ex) {
            formatter.getOutput();
            formatter.append(ex.toString());
        }
        return formatter.releaseOutput();
    }

    MixinMatch match(CssFormatter formatter, List<Expression> paramValues, boolean isDefault) {
        if (this.guard == null && formatter.containsRule(this)) {
            return null;
        }
        Map<String, Expression> mixinParameters = this.getMixinParams(formatter, paramValues);
        if (mixinParameters == NO_MATCH) {
            return null;
        }
        boolean matching = true;
        if (this.guard != null) {
            formatter.addGuardParameters(mixinParameters, isDefault);
            matching = this.guard.booleanValue(formatter);
            formatter.removeGuardParameters(mixinParameters);
        }
        return new MixinMatch(this, mixinParameters, matching, formatter.wasDefaultFunction());
    }

    boolean isMixin() {
        return this.params != null;
    }

    private boolean isValidCSS(CssFormatter formatter) {
        if (this.params == null) {
            if (this.guard != null) {
                return this.guard.booleanValue(formatter);
            }
            return true;
        }
        return false;
    }

    boolean isInlineRule(CssFormatter formatter) {
        if (this.selectors.length == 1 && this.selectors[0].equals("&")) {
            return this.hasOnlyInlineProperties(formatter);
        }
        return false;
    }

    boolean hasOnlyInlineProperties(CssFormatter formatter) {
        for (Formattable prop : this.properties) {
            if (!(prop instanceof Mixin)) continue;
            return false;
        }
        for (Rule rule : this.subrules) {
            if (!rule.isValidCSS(formatter)) continue;
            return false;
        }
        return true;
    }
}

