/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GcWebServiceError;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDef;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefSaveResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefToSave;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAttributeDefSaveRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.List;

public class GcAttributeDefSave {
    private String clientVersion;
    private List<WsAttributeDefToSave> attributeDefsToSave = new ArrayList<WsAttributeDefToSave>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private GcTransactionType txType;

    public GcAttributeDefSave assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcAttributeDefSave addAttributeDefToSave(WsAttributeDefToSave wsAttributeDefToSave) {
        this.attributeDefsToSave.add(wsAttributeDefToSave);
        return this;
    }

    public GcAttributeDefSave addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAttributeDefSave addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAttributeDefSave assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.attributeDefsToSave) == 0) {
            throw new RuntimeException("AttributeDef is required: " + this);
        }
    }

    public WsAttributeDefSaveResults execute() {
        this.validate();
        WsAttributeDefSaveResults wsAttributeDefSaveResults = null;
        try {
            WsRestAttributeDefSaveRequest attributeDefSave = new WsRestAttributeDefSaveRequest();
            attributeDefSave.setActAsSubjectLookup(this.actAsSubject);
            attributeDefSave.setTxType(this.txType == null ? null : this.txType.name());
            attributeDefSave.setWsAttributeDefsToSave(GrouperClientUtils.toArray(this.attributeDefsToSave, WsAttributeDefToSave.class));
            if (this.params.size() > 0) {
                attributeDefSave.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsAttributeDefSaveResults = (WsAttributeDefSaveResults)grouperClientWs.executeService("attributeDefs", attributeDefSave, "attributeDefSave", this.clientVersion, false);
            String attributeDefSaveResultMessage = "";
            try {
                attributeDefSaveResultMessage = wsAttributeDefSaveResults.getResults()[0].getResultMetadata().getResultMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String resultMessage = wsAttributeDefSaveResults.getResultMetadata().getResultMessage() + "\n" + attributeDefSaveResultMessage;
            grouperClientWs.handleFailure(wsAttributeDefSaveResults, wsAttributeDefSaveResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAttributeDefSaveResults;
    }

    public GcAttributeDefSave assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public static void main(String[] args) {
        WsAttributeDefToSave wsAttributeDefToSave = new WsAttributeDefToSave();
        wsAttributeDefToSave.setSaveMode("INSERT");
        WsAttributeDef wsAttributeDef1 = new WsAttributeDef();
        wsAttributeDef1.setName("test1:attributeDef1");
        wsAttributeDef1.setAttributeDefType("perm");
        wsAttributeDef1.setDescription("Perm Attribute Def");
        wsAttributeDef1.setAssignToGroup("T");
        wsAttributeDef1.setAssignToEffectiveMembership("T");
        wsAttributeDef1.setValueType("marker");
        wsAttributeDefToSave.setWsAttributeDef(wsAttributeDef1);
        try {
            WsAttributeDefSaveResults wsAttributeDefSaveResults = new GcAttributeDefSave().addAttributeDefToSave(wsAttributeDefToSave).execute();
            System.out.println(wsAttributeDefSaveResults.getResults()[0].getResultMetadata().getResultCode());
        }
        catch (GcWebServiceError gwse) {
            WsAttributeDefSaveResults wsAttributeDefSaveResults = (WsAttributeDefSaveResults)gwse.getContainerResponseObject();
            System.out.println(wsAttributeDefSaveResults.getResults()[0].getResultMetadata().getResultCode());
            gwse.printStackTrace();
        }
    }
}

