/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.WsMemberFilter;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsResponseMeta;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetMembersRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsResultMeta;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubject;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetMembers {
    private static Log LOG = GrouperClientUtils.retrieveLog(GcGetMembers.class);
    private Boolean autopage;
    private Integer autopageOverlap;
    private Integer pageSize;
    private Integer pageNumber;
    private String sortString;
    private Boolean ascending;
    private String clientVersion;
    private Set<String> groupNames = new LinkedHashSet<String>();
    private Set<String> groupUuids = new LinkedHashSet<String>();
    private Set<Long> groupIdIndexes = new LinkedHashSet<Long>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsMemberFilter memberFilter;
    private WsSubjectLookup actAsSubject;
    private String fieldName;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private Set<String> sourceIds = null;
    private Timestamp pointInTimeFrom;
    private Timestamp pointInTimeTo;
    private Boolean pageIsCursor;
    private String pageLastCursorField;
    private String pageLastCursorFieldType;
    private Boolean pageCursorFieldIncludesLastRetrieved;

    public static void main(String[] args) {
        GcGetMembers gcGetMembers = new GcGetMembers().addGroupName("penn:isc:nandt:apps:pennbox:user").addSubjectAttributeName("PENNNAME").assignAutopage(true);
        gcGetMembers.assignPageSize(10000);
        WsGetMembersResults wsGetMembersResults = gcGetMembers.execute();
        System.out.println("Found " + GrouperClientUtils.length(wsGetMembersResults.getResults()[0].getWsSubjects()));
        for (WsSubject wsSubject : wsGetMembersResults.getResults()[0].getWsSubjects()) {
            System.out.println(wsSubject.getAttributeValue(0));
        }
        System.out.println("Found " + GrouperClientUtils.length(wsGetMembersResults.getResults()[0].getWsSubjects()));
    }

    public GcGetMembers assignAutopage(Boolean theAutopage) {
        this.autopage = theAutopage;
        return this;
    }

    public GcGetMembers assignAutopageOverlap(Integer theAutopageOverlap) {
        this.autopageOverlap = theAutopageOverlap;
        return this;
    }

    public void assignPageSize(Integer pageSize1) {
        this.pageSize = pageSize1;
    }

    public void assignPageNumber(Integer pageNumber1) {
        this.pageNumber = pageNumber1;
    }

    public void assignSortString(String sortString1) {
        this.sortString = sortString1;
    }

    public void assignAscending(Boolean ascending1) {
        this.ascending = ascending1;
    }

    public GcGetMembers assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetMembers addGroupName(String theGroupName) {
        this.groupNames.add(theGroupName);
        return this;
    }

    public GcGetMembers addGroupIdIndex(Long theGroupIdIndex) {
        this.groupIdIndexes.add(theGroupIdIndex);
        return this;
    }

    public GcGetMembers addGroupUuid(String theGroupUuid) {
        this.groupUuids.add(theGroupUuid);
        return this;
    }

    public GcGetMembers addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetMembers addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetMembers assignMemberFilter(WsMemberFilter theMemberFilter) {
        this.memberFilter = theMemberFilter;
        return this;
    }

    public GcGetMembers assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.groupNames) == 0 && GrouperClientUtils.length(this.groupUuids) == 0 && GrouperClientUtils.length(this.groupIdIndexes) == 0) {
            throw new RuntimeException("Group name or uuid or id index is required: " + this);
        }
        if (this.pointInTimeFrom != null || this.pointInTimeTo != null) {
            if (this.includeGroupDetail != null && this.includeGroupDetail.booleanValue()) {
                throw new RuntimeException("Cannot specify includeGroupDetail for point in time queries.");
            }
            if (this.memberFilter != null && !this.memberFilter.equals((Object)WsMemberFilter.All)) {
                throw new RuntimeException("Cannot specify a member filter for point in time queries.");
            }
        }
        if (this.autopage != null && this.autopage.booleanValue() && this.pageNumber != null && this.pageNumber != 0) {
            throw new RuntimeException("Dont specify the pageNumber when autopaging");
        }
        if (this.autopage != null && this.autopage.booleanValue() && GrouperClientUtils.length(this.groupNames) + GrouperClientUtils.length(this.groupUuids) + GrouperClientUtils.length(this.groupIdIndexes) > 1) {
            throw new RuntimeException("If autopaging, just get members of one group!");
        }
    }

    public GcGetMembers assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcGetMembers addSourceId(String sourceId) {
        if (this.sourceIds == null) {
            this.sourceIds = new LinkedHashSet<String>();
        }
        this.sourceIds.add(sourceId);
        return this;
    }

    public GcGetMembers addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcGetMembers assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGetMembers assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public GcGetMembers assignPointInTimeFrom(Timestamp pointInTimeFrom) {
        this.pointInTimeFrom = pointInTimeFrom;
        return this;
    }

    public GcGetMembers assignPointInTimeTo(Timestamp pointInTimeTo) {
        this.pointInTimeTo = pointInTimeTo;
        return this;
    }

    public GcGetMembers assignPageIsCursor(Boolean pageIsCursor) {
        this.pageIsCursor = pageIsCursor;
        return this;
    }

    public GcGetMembers assignPageLastCursorField(String pageLastCursorField) {
        this.pageLastCursorField = pageLastCursorField;
        return this;
    }

    public GcGetMembers assignPageLastCursorFieldType(String pageLastCursorFieldType) {
        this.pageLastCursorFieldType = pageLastCursorFieldType;
        return this;
    }

    public GcGetMembers assignPageCursorFieldIncludesLastRetrieved(Boolean pageCursorFieldIncludesLastRetrieved) {
        this.pageCursorFieldIncludesLastRetrieved = pageCursorFieldIncludesLastRetrieved;
        return this;
    }

    public WsGetMembersResults execute() {
        this.validate();
        if (this.autopage == null || !this.autopage.booleanValue()) {
            return this.executeHelper();
        }
        if (this.pageSize == null || this.pageSize <= 2) {
            this.pageSize = 10000;
        }
        if (this.sortString == null) {
            this.sortString = "m.id";
        }
        if (this.autopageOverlap == null || this.autopageOverlap < 1) {
            this.autopageOverlap = (int)((double)this.pageSize.intValue() * 0.05);
            if (this.autopageOverlap < 1) {
                this.autopageOverlap = 1;
            }
        }
        long nowNanos = System.nanoTime();
        for (int outerLoop = 0; outerLoop < 5; ++outerLoop) {
            WsGetMembersResults wsGetMembersResultsOuter = new WsGetMembersResults();
            WsResponseMeta wsResponseMetaOuter = new WsResponseMeta();
            wsGetMembersResultsOuter.setResponseMetadata(wsResponseMetaOuter);
            WsResultMeta wsResultMetaOuter = new WsResultMeta();
            wsGetMembersResultsOuter.setResultMetadata(wsResultMetaOuter);
            StringBuilder resultWarnings = new StringBuilder();
            StringBuilder resultMessage = new StringBuilder();
            WsGetMembersResult wsGetMembersResultOuter = null;
            ArrayList<WsSubject> wsSubjectListOuter = new ArrayList<WsSubject>();
            HashSet<MultiKey> sourceIdSubjectIdIdentifier = new HashSet<MultiKey>();
            boolean firstRun = true;
            int ttl = 10000;
            int originalPageSize = this.pageSize;
            int lastIndexRetrieved = -1;
            try {
                block23: {
                    do {
                        this.calculatePaging(originalPageSize, lastIndexRetrieved);
                        if (LOG.isDebugEnabled()) {
                            int fromIndex = (this.pageNumber - 1) * this.pageSize;
                            int toIndex = this.pageNumber * this.pageSize - 1;
                            LOG.debug("Retrieving records: " + fromIndex + " - " + toIndex + ", pageSize: " + this.pageSize + ", pageNumber: " + this.pageNumber);
                        }
                        WsGetMembersResults wsGetMembersResultsInner = this.executeHelper();
                        lastIndexRetrieved = (this.pageNumber - 1) * this.pageSize - 1 + GrouperClientUtils.length(wsGetMembersResultsInner.getResults()[0].getWsSubjects());
                        boolean hasOverlap = false;
                        for (WsGetMembersResult wsGetMembersResult : GrouperClientUtils.nonNull(wsGetMembersResultsInner.getResults(), WsGetMembersResult.class)) {
                            if (wsGetMembersResultOuter == null) {
                                wsGetMembersResultOuter = wsGetMembersResult;
                            }
                            for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsGetMembersResult.getWsSubjects(), WsSubject.class)) {
                                MultiKey multiKey = new MultiKey(wsSubject.getSourceId(), wsSubject.getId(), wsSubject.getIdentifierLookup());
                                if (sourceIdSubjectIdIdentifier.contains(multiKey)) {
                                    hasOverlap = true;
                                    continue;
                                }
                                sourceIdSubjectIdIdentifier.add(multiKey);
                                wsSubjectListOuter.add(wsSubject);
                            }
                        }
                        if (firstRun) {
                            wsGetMembersResultsOuter.setSubjectAttributeNames(wsGetMembersResultsInner.getSubjectAttributeNames());
                            wsResponseMetaOuter.setServerVersion(wsGetMembersResultsInner.getResponseMetadata().getServerVersion());
                            wsResultMetaOuter.setParams(wsGetMembersResultsInner.getResultMetadata().getParams());
                            wsResultMetaOuter.setResultCode(wsGetMembersResultsInner.getResultMetadata().getResultCode());
                            wsResultMetaOuter.setResultCode2(wsGetMembersResultsInner.getResultMetadata().getResultCode2());
                            wsResultMetaOuter.setSuccess(wsGetMembersResultsInner.getResultMetadata().getSuccess());
                        } else if (!hasOverlap) break block23;
                        if (GrouperClientUtils.length(wsGetMembersResultsInner.getResponseMetadata().getResultWarnings()) > 0) {
                            resultWarnings.append(wsGetMembersResultsInner.getResponseMetadata().getResultWarnings() + "\n");
                        }
                        if (GrouperClientUtils.length(wsGetMembersResultsInner.getResultMetadata().getResultMessage()) > 0) {
                            resultMessage.append(wsGetMembersResultsInner.getResultMetadata().getResultMessage() + "\n");
                        }
                        if (GrouperClientUtils.length(wsGetMembersResultsInner.getResults()[0].getWsSubjects()) < this.pageSize) {
                            wsGetMembersResultsOuter.setResults(new WsGetMembersResult[]{wsGetMembersResultOuter});
                            if (GrouperClientUtils.length(wsSubjectListOuter) > 0) {
                                wsGetMembersResultOuter.setWsSubjects(GrouperClientUtils.toArray(wsSubjectListOuter, WsSubject.class));
                            }
                            wsResponseMetaOuter.setResultWarnings(resultWarnings.toString());
                            wsResponseMetaOuter.setMillis("" + (System.nanoTime() - nowNanos) / 10000L);
                            wsResultMetaOuter.setResultMessage(resultMessage.toString());
                            WsGetMembersResults wsGetMembersResults = wsGetMembersResultsOuter;
                            return wsGetMembersResults;
                        }
                        firstRun = false;
                    } while (--ttl >= 0);
                    throw new RuntimeException("TTL is less than 0, started at 100k...  endless loop?  page size too small?");
                }
                GrouperClientUtils.sleep(30000L);
                continue;
            }
            finally {
                this.pageSize = originalPageSize;
            }
        }
        throw new RuntimeException("Tried 5 times to get the paged result, but the data changed too frequently!  Error!");
    }

    private static void printPagingReport() {
        int toIndex;
        GcGetMembers gcGetMembers = new GcGetMembers();
        gcGetMembers.pageSize = 1000;
        gcGetMembers.autopageOverlap = 50;
        int lastIndex = -1;
        do {
            gcGetMembers.calculatePaging(1000, lastIndex);
            int fromIndex = (gcGetMembers.pageNumber - 1) * gcGetMembers.pageSize;
            toIndex = gcGetMembers.pageNumber * gcGetMembers.pageSize - 1;
            System.out.println("Retrieving records: " + fromIndex + " - " + toIndex + ", pageSize: " + gcGetMembers.pageSize + ", pageNumber: " + gcGetMembers.pageNumber);
            lastIndex = toIndex;
        } while (toIndex <= 70000);
    }

    private void calculatePaging(int originalPageSize, int lastIndexRetrieved) {
        int wasPageSize = this.pageSize == null ? -1 : this.pageSize;
        int wasPageNumber = this.pageNumber == null ? -1 : this.pageNumber;
        this.calculatePagingHelper(originalPageSize, lastIndexRetrieved);
        if (this.pageSize == wasPageSize && this.pageNumber == wasPageNumber) {
            throw new RuntimeException("Paging not working, stuck on page number: originalPageSize: " + originalPageSize + ", lastIndexRetrieved: " + lastIndexRetrieved + ", pageNumber: " + this.pageNumber + ", pageSize: " + this.pageSize);
        }
    }

    private void calculatePagingHelper(int originalPageSize, int lastIndexRetrieved) {
        int pageSizeAdd = (int)Math.max((double)originalPageSize * 0.1, 50.0);
        if (lastIndexRetrieved == -1) {
            this.pageNumber = 1;
            this.pageSize = originalPageSize + 3 * pageSizeAdd;
            return;
        }
        int highBound = originalPageSize + 3 * pageSizeAdd;
        int lowBound = originalPageSize - 3 * pageSizeAdd;
        int[] pageSizesToRecords = new int[1 + highBound - lowBound];
        int[] pageSizesToRemainders = new int[1 + highBound - lowBound];
        for (int i = 0; i < pageSizesToRecords.length; ++i) {
            int localPageSize = lowBound + i;
            pageSizesToRemainders[i] = lastIndexRetrieved % localPageSize;
            pageSizesToRecords[i] = localPageSize - pageSizesToRemainders[i];
        }
        int bestIndex = -1;
        int bestRecords = -1;
        for (int i = 0; i < pageSizesToRecords.length; ++i) {
            if (pageSizesToRemainders[i] < this.autopageOverlap || pageSizesToRecords[i] <= bestRecords) continue;
            bestIndex = i;
            bestRecords = pageSizesToRecords[i];
        }
        if (bestIndex > -1) {
            this.pageSize = bestIndex + lowBound;
            this.pageNumber = lastIndexRetrieved / this.pageSize + 1;
            return;
        }
        bestIndex = -1;
        int bestRemainder = -1;
        for (int i = 0; i < pageSizesToRecords.length; ++i) {
            if (pageSizesToRemainders[i] < bestRemainder) continue;
            bestIndex = i;
            bestRemainder = pageSizesToRemainders[i];
        }
        if (bestIndex > -1) {
            this.pageSize = bestIndex + lowBound;
            this.pageNumber = lastIndexRetrieved / this.pageSize + 1;
            return;
        }
        throw new RuntimeException("Cant find a pageSize and pageNumber: originalPageSize: " + originalPageSize + ", originalAutoPageOverlap: " + this.autopageOverlap + ", lastIndexRetrieved: " + lastIndexRetrieved);
    }

    private WsGetMembersResults executeHelper() {
        WsGetMembersResults wsGetMembersResults = null;
        try {
            WsRestGetMembersRequest getMembers = new WsRestGetMembersRequest();
            getMembers.setActAsSubjectLookup(this.actAsSubject);
            getMembers.setFieldName(this.fieldName);
            getMembers.setMemberFilter(this.memberFilter == null ? null : this.memberFilter.name());
            ArrayList<WsGroupLookup> groupLookups = new ArrayList<WsGroupLookup>();
            for (String groupName : this.groupNames) {
                groupLookups.add(new WsGroupLookup(groupName, null));
            }
            for (String groupUuid : this.groupUuids) {
                groupLookups.add(new WsGroupLookup(null, groupUuid));
            }
            for (Long groupIdIndex : this.groupIdIndexes) {
                groupLookups.add(new WsGroupLookup(null, null, groupIdIndex.toString()));
            }
            getMembers.setWsGroupLookups(GrouperClientUtils.toArray(groupLookups, WsGroupLookup.class));
            if (this.includeGroupDetail != null) {
                getMembers.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                getMembers.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.subjectAttributeNames.size() > 0) {
                getMembers.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            if (this.params.size() > 0) {
                getMembers.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            if (GrouperClientUtils.length(this.sourceIds) > 0) {
                getMembers.setSourceIds(GrouperClientUtils.toArray(this.sourceIds, String.class));
            }
            if (this.ascending != null) {
                getMembers.setAscending(this.ascending != false ? "T" : "F");
            }
            getMembers.setSortString(this.sortString);
            if (this.pageNumber != null) {
                getMembers.setPageNumber(this.pageNumber.toString());
            }
            if (this.pageSize != null) {
                getMembers.setPageSize(this.pageSize.toString());
            }
            getMembers.setPointInTimeFrom(GrouperClientUtils.dateToString(this.pointInTimeFrom));
            getMembers.setPointInTimeTo(GrouperClientUtils.dateToString(this.pointInTimeTo));
            if (this.pageIsCursor != null) {
                getMembers.setPageIsCursor(this.pageIsCursor != false ? "T" : "F");
            }
            if (this.pageCursorFieldIncludesLastRetrieved != null) {
                getMembers.setPageCursorFieldIncludesLastRetrieved(this.pageCursorFieldIncludesLastRetrieved != false ? "T" : "F");
            }
            getMembers.setPageLastCursorField(this.pageLastCursorField);
            getMembers.setPageLastCursorFieldType(this.pageLastCursorFieldType);
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGetMembersResults = (WsGetMembersResults)grouperClientWs.executeService("groups", getMembers, "getMembers", this.clientVersion, true);
            String resultMessage = wsGetMembersResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetMembersResults, wsGetMembersResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetMembersResults;
    }
}

