/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver;

import edu.uci.qa.browserdriver.utils.Browser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class BrowserConfig {
    private static final String FILE_NAME = ".browser";
    private static final Browser BROWSER = Browser.Chrome;
    private static final String[] DEFAULT_BROWSER = new String[]{"BROWSER", "BROWSER_NAME", "BROWSERNAME", "DEFAULT_BROWSER", "DEFAULTBROWESR", "browser", "browser_name", "browsername", "default_browser", "defaultbrowser"};
    private static final String[] DRIVER_LOCATION = new String[]{"_DRIVER", "DRIVER", "_driver", "driver"};
    private static final String DRIVER = "DRIVER";
    private static final String SAVE_FOLDER = "save_folder";
    private static final String PROP_DEFAULT = "browser.default";
    private static final String PROP_CHROME = "browser.chromeDriver";
    private static final String PROP_IE = "browser.internetExplorerDriver";
    private static final String PROP_OPERA = "browser.operaDriver";
    private static final String PROP_EDGE = "browser.edgeDriver";
    private static final String PROP_PHANTOM = "browser.phantomDriver";
    private static final String PROP_GECKO = "browser.geckoDriver";
    private static final String PROP_FOLDER = "browser.saveFolder";
    private Browser defaultBrowser = Browser.None;
    private String chromeDriver = null;
    private String internetExplorerDriver = null;
    private String operaDriver = null;
    private String edgeDriver = null;
    private String phantomDriver = null;
    private String geckoDriver = null;
    private String saveFolder = null;
    private static BrowserConfig instance = null;

    public BrowserConfig() {
        File global = new File(new File(System.getProperty("user.home")), FILE_NAME);
        File relative = new File(FILE_NAME);
        InputStream local = Thread.currentThread().getContextClassLoader().getResourceAsStream(FILE_NAME);
        try {
            if (global.exists()) {
                this.readPropStream(new FileInputStream(global));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (local != null) {
            this.readPropStream(local);
        }
        try {
            if (relative.exists()) {
                this.readPropStream(new FileInputStream(relative));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (System.getProperty("wdm.targetPath") == null) {
            System.setProperty("wdm.targetPath", "./webdrivers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropStream(InputStream stream) {
        Properties props = new Properties();
        try {
            props.load(stream);
            this.defaultBrowser = Browser.fromString(props.getProperty(PROP_DEFAULT));
            this.chromeDriver = props.getProperty(PROP_CHROME);
            this.internetExplorerDriver = props.getProperty(PROP_IE);
            this.operaDriver = props.getProperty(PROP_OPERA);
            this.edgeDriver = props.getProperty(PROP_EDGE);
            this.phantomDriver = props.getProperty(PROP_PHANTOM);
            this.geckoDriver = props.getProperty(PROP_GECKO);
            this.saveFolder = props.getProperty(PROP_FOLDER);
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                if (!((String)prop.getKey()).startsWith("wdm") || BrowserConfig.getPropertyOrEnvironmentVariable((String)prop.getKey()) != null) continue;
                System.setProperty((String)prop.getKey(), (String)prop.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Browser getBrowser() {
        String s;
        String temp;
        Browser browser = this.defaultBrowser;
        String[] stringArray = DEFAULT_BROWSER;
        int n = stringArray.length;
        for (int i = 0; i < n && ((temp = BrowserConfig.getPropertyOrEnvironmentVariable(s = stringArray[i])) == null || (browser = Browser.fromString(temp)) == Browser.None); ++i) {
        }
        if (browser == Browser.None) {
            return BROWSER;
        }
        return browser;
    }

    public File getSaveFolder() {
        File out = null;
        String folder = BrowserConfig.getPropertyOrEnvironmentVariable(SAVE_FOLDER);
        if (this.saveFolder != null) {
            out = new File(this.saveFolder);
        }
        if (folder != null) {
            out = new File(folder);
        }
        if (out != null) {
            out.mkdirs();
            if (out.isDirectory()) {
                return out;
            }
        }
        return new File("./target/browserdriver/");
    }

    public String getDriverLocation(Browser browser) {
        String location = null;
        if (browser == Browser.Chrome) {
            location = this.chromeDriver;
        } else if (browser == Browser.IE) {
            location = this.internetExplorerDriver;
        } else if (browser == Browser.Opera) {
            location = this.operaDriver;
        } else if (browser == Browser.Edge) {
            location = this.edgeDriver;
        } else if (browser == Browser.Phantom) {
            location = this.phantomDriver;
            String out = BrowserConfig.getPropertyOrEnvironmentVariable("TRAVIS");
            if (out != null && out.equals("true")) {
                return BrowserConfig.getPropertyOrEnvironmentVariable("phantomjs");
            }
        } else if (browser == Browser.Firefox) {
            location = this.geckoDriver;
        }
        if (BrowserConfig.getPropertyOrEnvironmentVariable(DRIVER) != null) {
            location = BrowserConfig.getPropertyOrEnvironmentVariable(DRIVER);
        }
        for (String l : DRIVER_LOCATION) {
            String temp = BrowserConfig.getPropertyOrEnvironmentVariable(browser + l);
            if (temp == null) continue;
            location = temp;
            break;
        }
        return location;
    }

    private static String getPropertyOrEnvironmentVariable(String property) {
        String value = System.getProperty(property);
        if (value == null || value.equals("")) {
            value = System.getenv(property);
        }
        if (value == null || value.equals("")) {
            value = null;
        }
        return value;
    }

    public static BrowserConfig getInstance() {
        if (instance == null) {
            instance = new BrowserConfig();
        }
        return instance;
    }
}

