/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.qa.browserdriver.drivers;

import edu.uci.qa.browserdriver.BrowserConfig;
import edu.uci.qa.browserdriver.BrowserDriver;
import edu.uci.qa.browserdriver.utils.Browser;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;
import java.util.ArrayList;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomBrowserDriver
extends BrowserDriver
implements WebDriver {
    protected PhantomBrowserDriver(Browser browser, Capabilities capabilities) {
        super(browser, capabilities);
    }

    @Override
    protected WebDriver newInstance(Capabilities capabilities) {
        return new PhantomJSDriver(capabilities);
    }

    @Override
    protected boolean setupDriver() {
        String driver = BrowserConfig.getInstance().getDriverLocation(this.getBrowser());
        if (driver != null) {
            System.setProperty("phantomjs.binary.path", driver);
        } else {
            PhantomJsDriverManager.getInstance().setup();
        }
        return true;
    }

    public static Capabilities desiredCapabilities() {
        ArrayList<String> cliArgsCap = new ArrayList<String>();
        DesiredCapabilities caps = DesiredCapabilities.phantomjs();
        cliArgsCap.add("--web-security=false");
        cliArgsCap.add("--ssl-protocol=any");
        caps.setCapability("takesScreenshot", true);
        caps.setCapability("phantomjs.cli.args", cliArgsCap);
        caps.setCapability("phantomjs.ghostdriver.cli.args", (Object)new String[]{"--logLevel=2"});
        return caps;
    }
}

